procedure arguments;
{ handles the command line parameters for SORT }
{ Copyright 1988,1989, by J. W. Rider }

{ Upon exit, the global variable "parmcount" is the index
  of the first non-switch parameter }

{ The general approach is to permit both "/" and "-" as
  valid switch indicators.  With "/", only a single switch
  can be specified, but the options can be packed together
  without any spacing. ("/a/b/c" is okay and means the same as "/a /b /c",
  but "/abc" is not.)  With "-", multiple switches can be specified but
  individual "-" must be preceded by a space. ("-abc" is okay and means
  the same as "-a -b -c", but "-a-b-c" is invalid.) }

{ Unlike Unix implementations, either upper or lower case characters
  can be used for switches. }

var i,j:integer; parm:string;
begin i:=1;

{ handle the option switches }
if paramcount>0 then begin
   parm:=paramstr(i);
   while ((length(parm)>1) and (parm[1] in ['-','/'])) do begin

           if parm[2] in ['b','B'] then ignoreblanks:=true
      else if parm[2] in ['c','C'] then sensecase:=not defaultcase
      else if parm[2] in ['d','D'] then ancase:=true
      else if parm[2] in ['f','F'] then usefields:=true
      else if parm[2] in ['h','H'] then helponly:=true
      else if parm[2] in ['k','K'] then keysonly:=true
      else if parm[2] in ['n','N'] then sortnumeric:=true
      else if parm[2] in ['r','R'] then reversed:=true
      else if parm[2] in ['t','T'] then
           if length(parm)>2 then begin
              delimset:=delimset + [ parm[3] ];
              parm:=copy(parm,1,2)+copy(parm,4,255); end
           else delimset:=delimset+[^I,' ']
      else if parm[2] in ['u','U'] then unique:=true
      else begin
         parm[1]:='/'; { needed for option chaining to work properly }
         j:=trunc(bval(copy(parm,2,length(parm)-1)));
         if (j>=1) and (j<255) then
            if keycol=0 then keycol:=j
            else if keycol2=0 then keycol2:=j; end;

      if parm[1]='/' then begin
         j:=pos('/',copy(parm,2,length(parm)-1));
         if j>0 then begin
            parm:=copy(parm,j+1,length(parm)-j);
            if length(parm)<1 then begin
               inc(i); parm:=paramstr(i); end; end
         else begin inc(i); parm:=paramstr(i); end; end
      else begin parm:='-'+copy(parm,3,length(parm)-2);
         if length(parm)<2 then begin
            inc(i); parm:=paramstr(i); end; end; end; end;

parmcount:=i; end; {procedure arguments}

