(* ---------------------------------- *)
(* Error                              *)
(* Copyright (c) 1994 by Dado Colussi *)
(* All rights reserved                *)
(* ---------------------------------- *)


UNIT Error;


INTERFACE


USES

  CRT;


TYPE

  ErrorPriorities       = (ignore, wait, dead_end, fatal);

(*
  ignore        = Ignore the damage (if any) of the error
  wait          = Wait acknowledgement until continue
  dead_end      = The error causes such damage that the program cannot
                  continue in that way but there is no need to terminate
                  the whole program (for example, if the user tries to
                  initialize an UART that doesn't exist, the main
                  program may allow the user to redifine the base
                  address).
  fatal         = The error causes such damage that the program must be
                  terminated immediatelly.

*)

VAR
  error_alarm           : Boolean;


PROCEDURE PrintError(error_msg : String; priority : ErrorPriorities);


IMPLEMENTATION


CONST

  NUL   : Char = #0;


PROCEDURE PrintError(error_msg : String; priority : ErrorPriorities);
BEGIN
  WriteLn('Error: ', error_msg);
  CASE priority OF
    ignore      : ;
    wait        : REPEAT
                  UNTIL Mem[$40:$1A] <> Mem[$40:$1C];
    dead_end    : error_alarm := TRUE;
    fatal       : Halt;
  END; (* CASE *)
END; (* PrintError *)

BEGIN
  error_alarm := FALSE;
END. (* Error *)

