(* UART tester *)

PROGRAM UART;


USES

  Regs,
  Consts,
  Hex;


CONST

  USAGE = 'Usage: UART base_address [...]';


VAR

  i     : Byte;
  base  : Word;


FUNCTION DetectUART(base : Word) : Byte;
CONST
  VAL_1 = $F;
  VAL_2 = $A;

VAR
  uart_type     : Byte;
  original,
  check_1,
  check_2       : Byte;

BEGIN
  uart_type := UART_NONE;
  original := Port[base + IER];
  Port[base + IER] := VAL_1;
  check_1 := Port[base + IER];
  Port[base + IER] := VAL_2;
  check_2 := Port[base + IER];
  Port[base + IER] := original;
  IF (check_1 = VAL_1) AND (check_2 = VAL_2) THEN
    BEGIN
      uart_type := UART_INS8250;
      original := Port[base + SCR];
      Port[base + SCR] := VAL_1;
      check_1 := Port[base + SCR];
      Port[base + SCR] := VAL_2;
      check_2 := Port[base + SCR];
      Port[base + SCR] := original;
      IF (check_1 = VAL_1) AND (check_2 = VAL_2) THEN
        BEGIN
          uart_type := UART_NS16450;
          Port[base + FCR] := FCR_FIFO_ENABLE + FCR_RCVR_TRIGGER_LSB + FCR_RCVR_TRIGGER_MSB;
          CASE Port[base + IIR] AND (IIR_FIFOE0 + IIR_FIFOE1) OF
            IIR_FIFOE0              : uart_type := UART_NS16550;
            IIR_FIFOE1              : uart_type := UART_NS16550;
            IIR_FIFOE0 + IIR_FIFOE1 : uart_type := UART_NS16550A;
          END; (* CASE *)
        END; (* IF *)
    END; (* IF *)
  DetectUART := uart_type;
END; (* DetectUART *)


BEGIN
  IF ParamCount = 0 THEN
    WriteLn(USAGE)
  ELSE
    FOR i := 1 TO ParamCount DO
      BEGIN
        base := HexToDec(ParamStr(i));
        CASE DetectUART(base) OF
          UART_NONE     : WriteLn('No UART detected at address ', HexW(base));
          UART_UNKNOWN  : WriteLn('Unknown UART detected at address ', HexW(base));
          UART_INS8250  : WriteLn('INS8250 UART detected at address ', HexW(base));
          UART_NS16450  : WriteLn('NS16450 UART detected at address ', HexW(base));
          UART_NS16550  : WriteLn('NS16550 UART detected at address ', HexW(base));
          UART_NS16550A : WriteLn('NS16550A UART detected at address ', HexW(base));
        END; (* CASE *)
      END; (* FOR *)
  WriteLn;
END. (* UART *)
