(* ----------------------------------------------------------- *)
(* Hex                                                         *)
(* Copyright (c) 1992-94 by Claus Ziegler (ziegler@winboss.dk) *)
(* Code modified by Dado Colussi                               *)
(* ----------------------------------------------------------- *)


UNIT Hex;


INTERFACE


TYPE

  String2       = String[2];    (* Byte -> Hex *)
  String4       = String[4];    (* Word & Integer -> Hex *)
  String8       = String[8];    (* Longint -> Hex *)
  String9       = String[9];    (* Pointer -> Hex *)


FUNCTION HexB(b : Byte) : String2;         (* Returns Byte in Hex *)
FUNCTION HexW(w : Word) : String4;         (* Returns Word in Hex *)
FUNCTION HexI(i : Integer) : String4;      (* Returns Integer in Hex *)
FUNCTION HexL(l : LongInt) : String8;      (* Returns Longint in Hex *)
FUNCTION HexP(p : Pointer) : String9;      (* Returns Pointer in Hex *)
FUNCTION HexToDec(hex : String) : LongInt; (* Returns Hex in Dec *)


IMPLEMENTATION


FUNCTION HexB(b : Byte) : String2;
CONST
  DIGITS        : ARRAY [0..$F] OF Char = '0123456789ABCDEF';

BEGIN
  HexB[0] := #2;
  HexB[1] := DIGITS[b SHR 4];
  HexB[2] := DIGITS[b AND $F];
END; (* HexB *)

FUNCTION HexW(w : Word) : String4;
BEGIN
  HexW := HexB(Hi(w)) + HexB(Lo(w));
END; (* HexW *)

FUNCTION HexI(i : Integer) : String4;
BEGIN
  HexI := HexW(Word(i));
END; (* HexI *)

FUNCTION HexL(l : Longint) : String8;
TYPE
  LR            =
    RECORD
      LW        : Word;
      HW        : Word;
    END; (* LR *)

BEGIN
  HexL := HexB(Hi(LR(l).HW)) +
          HexB(Lo(LR(l).HW)) +
          HexB(Hi(LR(l).LW)) +
          HexB(Lo(LR(l).LW));
END; (* HexL *)

FUNCTION HexP(p : Pointer) : String9;
BEGIN
  HexP := HexW(Seg(p^)) + 'x' + HexW(Ofs(p^));
END; (* HexP *)

FUNCTION HexToDec(hex : String) : LongInt;
VAR
  tmp  : String;
  tal  : LongInt;
  code : Integer;

BEGIN
  tmp := hex;
  WHILE (tmp[1] = ' ') AND (Byte(tmp[0]) > 0) DO
    tmp := Copy(tmp, 2, Byte(tmp[0]) - 1);
  IF tmp[1] <> '$' THEN
    tmp := '$' + tmp;
  WHILE NOT (tmp[Ord(tmp[0])] IN ['1'..'9','0','a'..'f','A'..'F']) DO
    Dec(tmp[0]);
  Val(tmp, tal, code);
  IF code = 0 THEN
    HexToDec := tal
  ELSE
    HexToDec := 0;
END; (* HexToDec *)

END. (* Hex *)

