(* ---------------------------------- *)
(* Consts                             *)
(* Copyright (c) 1994 by Dado Colussi *)
(* All rights reserved                *)
(* ---------------------------------- *)


UNIT Consts;


INTERFACE


CONST

  BIT_0               = 1;
  BIT_1               = 2;
  BIT_2               = 4;
  BIT_3               = 8;
  BIT_4               = 16;
  BIT_5               = 32;
  BIT_6               = 64;
  BIT_7               = 128;
  BIT_8               = 256;
  BIT_9               = 512;
  BIT_10              = 1024;
  BIT_11              = 2048;
  BIT_12              = 4096;
  BIT_13              = 8192;
  BIT_14              = 16384;
  BIT_15              = 32768;

  NO_ERROR              = 0;
  ERROR_INVALID_PORT    = 1;
  ERROR_PORT_IN_USE     = 2;
  ERROR_INVALID_FIFO    = 3;
  ERROR_INVALID_BUFFER  = 4;
  ERROR_ILLEGAL_IRQ     = 5;
  ERROR_IRQ_IN_USE      = 6;

  UART_NONE             = 0;
  UART_UNKNOWN          = 1;
  UART_INS8250          = 2;
  UART_NS16450          = 3;
  UART_NS16550          = 4;    (* NEVER use FIFOs with this UART!!! *)
  UART_NS16550A         = 5;

  FIFO_NONE             = 0;
  FIFO_1                = BIT_0;
  FIFO_4                = BIT_0 + BIT_6;
  FIFO_8                = BIT_0 + BIT_7;
  FIFO_14               = BIT_0 + BIT_6 + BIT_7;

  SPEED_1200            = 0;
  SPEED_2400            = 1;
  SPEED_9600            = 2;
  SPEED_19200           = 3;
  SPEED_38400           = 4;
  SPEED_57600           = 5;
  SPEED_115200          = 6;

  DATA_BITS_5           = 0;
  DATA_BITS_6           = BIT_0;
  DATA_BITS_7           = BIT_1;
  DATA_BITS_8           = BIT_0 + BIT_1;

  PARITY_NONE           = 0;
  PARITY_EVEN           = BIT_3 + BIT_4;
  PARITY_ODD            = BIT_3;
  PARITY_MARK           = 0;                    (* ??? *)
  PARITY_SPACE          = 0;                    (* ??? *)

  STOP_BITS_1           = 0;
  STOP_BITS_2           = BIT_2;

  FLOW_RTS_CTS          = 1;
  FLOW_XON_XOFF         = 2;


IMPLEMENTATION


END. (* Consts *)

