{ This program demonstrates the use of the procedure Sideways and
  the unit SideUnit.  The prompt to check the printer is just a
  precaution because the program bombs if a printer is unavailable.
  Katherine Degerberg
}

Program TestSide;
uses SideUnit,Crt;

var
   Ch       : Char;     { Response Character }
   FileName : String;   { Name of File to Printe }
   IBM      : Boolean;  { Flag indicating type of printer }

begin

     { Get the printer type.  Only two main types are supported:
       IBM and compatibles and Epson and compatibles. }

     Write('Do you have an IBM printer? [Y/n] : ');
     ch := Readkey; if ch = #0 then ch := Readkey;
     Writeln;

     if UpCase(ch) = 'N' then
        IBM := False
     else
        IBM := True;

     { Get the name of the file to be printed }
     FileName := '';
     repeat
        Writeln;
        Write('Enter name of file to be printed sideways: ');
        Readln(FileName); Writeln;
        If Filename = '' then Writeln('Invalid File Name');
     until FileName <> '';
     Writeln;

     { Prompt to check the printer - just in case }
     Writeln('Check Printer  --- Press Any Key to Continue');
     ch := Readkey; if ch = #0 then ch := Readkey;
     Writeln;
     Writeln('Printing File....');
     Writeln;


     { Sideways will return false if it could not find the
       file to print it, so check what Sideways returns and
       print an appropriate message. }
     if Sideways(FileName,IBM) then
        Writeln('File Successfully Printed')
     else
        Writeln('File does not exist, try again');
     Writeln;

end. { of program TestSide }
