
unit Search;       (* Fast sequential byte/string searching routines. *)
                   (* Data-type you are searching must be 64K or less *)
                   (* in size.                                        *)
                   (* Donated to the public domain by Reuben Sumner.  *)

interface
                   (* Function to find a byte within a sequential     *)
                   (* data-type. (Maximum 64K for data-type.)         *)
                   (* Data is the data-type you want to search,       *)
                   (* Size is the size in bytes of the data-type      *)
                   (* you want to search, Num is the byte you are     *)
                   (* looking for. Returns the byte offset if found,  *)
                   (* zero if not found.                              *)

  function FindByte(var Data; Size : word; Num : byte) : word;


                   (* Fuction to find a string within a sequential    *)
                   (* data-type. (Maximum 64K for data-type.)         *)
                   (* Data is the data-type you want to search,       *)
                   (* Size is the size in bytes of the data-type      *)
                   (* you want to search, St is the string you are    *)
                   (* looking for. Returns the byte offset if found,  *)
                   (* zero if not found.                              *)

  function StrPos(var Data; Size : word; St : string) : word;

implementation

{$L SEARCH.OBJ}

{$F+}
  function FindByte(var Data; Size : word; Num : byte) : word; external;
  function StrPos(var Data; Size : word; St : string) : word; external;
{$F-}

END.

