program PrintPas;
{
                         SOURCE LISTER PROGRAM

   This is a simple program to list your TURBO PASCAL source programs
   to the printer in a neat format.  It replaces tab characters with
   spaces so printouts will have spacing other than the default printer
   tab setting of 8.  Set the const TabLength = to the length you use
   in Turbo Options Environment  I usually have it set to 3.
   The program also detects end-of-page and performs a perforation skip.
   The program accepts command-line input as in 'printpas test.pas'.
   This program was adapted from the Lister.pas file Borland provides
   as a demo program.
}

uses
  Printer;

const
  PageWidth = 80;
  PrintLength = 54;
  PathLength  = 65;
  FormFeed = #12;
  HorzTab = #9;
  VerticalTabLength = 3;
  TabLength = 3;

type
  WorkString = string[126];
  FileName  = string[PathLength];

var
  CurRow : integer;
  MainFileName: FileName;
  MainFile: text;

procedure Initialize;
  begin
    CurRow := 0;
  end {initialize};

function Open(var fp:text; name: Filename): boolean;
  begin
    Assign(fp,Name);
    {$I-}
    Reset(fp);
    {$I+}
    Open := IOResult = 0;
  end { Open };

procedure OpenMain;
  begin
    if ParamCount = 0 then
    begin
      Write('Enter filename: ');
      Readln(MainFileName);
    end
    else
      MainFileName := ParamStr(1);

    if (MainFileName = '') or not Open(MainFile,MainFileName) then
    begin
      Writeln('ERROR:  file not found (', MainFileName, ')');
      Halt(1);
    end;
  end {Open Main};

procedure VerticalTab;
  var i: integer;
  begin
    for i := 1 to VerticalTabLength do Writeln(LST);
  end {vertical tab};

procedure NewLine;
  begin
    CurRow := Succ(CurRow);
    if CurRow > PrintLength then      { test for perforation skip }
    begin
      Write(LST,FormFeed);
      VerticalTab;
      CurRow := 1;
    end;
  end {NewLine};

procedure ProcessFile;
  { This procedure displays the contents of the Turbo Pascal program on the }
  { printer.  }

  var
    LineBuffer: WorkString;
    j: integer;
    t: char;

  begin  {Process File}
    VerticalTab;
    Writeln('Printing . . . ');
    while not EOF(mainfile) do
    begin
      Read(MainFile,t);
      if t <> HorzTab then
         begin
            Write(LST,t);
            if t = chr(13) then
               NewLine;
            end
      else
         begin
            for j := 1 to TabLength do
               Write(LST,chr(32));
         end;
    end;
    Close(MainFile);
    Write(LST,FormFeed); { move the printer to the beginning of the next }
                         { page }
  end {Process File};


begin
  Initialize;      { initialize some global variables }
  OpenMain;        { open the file to print }
  ProcessFile;     { print the program }
end.
