program PPC ;
{
 Title        : PPC.PAS   -  Parallel Port Control
 Author       : Robert Upleger
 Date         : March 24, 1991
 Class        : CSC 335-80  - Spring 1991 - R. A. Peloso
 Objective    : To gain familiarity with the interface and control
                 aspects of the IBM-PC parallel port.
 Intent       : Prints a disk file using direct control of the parallel
                 port hardware.  Will not use any interrupts.
}
uses    crt , dos , timer ;             { timer unit returns Current_Sec   }

const   end_of_file  : char = #26     ; { ASCII code for end of file       }
        time_delay   : integer = 10   ; { default time delay till shutdown }

var     ch           : char           ; { one char of text file or input   }
        f            : text           ; { text file                        }
        filename,                       { user inputted filename           }
        message      : string         ; { printer status message           }
        ready        : boolean        ; { printer status vailidity         }
        BaseAddress  : word           ; { port number for data function    }

      {--------------------------------------------------------------------}
        procedure PrinterStatus ( var msg : string ; var test : boolean ) ;
        { Assigns and updates the printer status port.  Detects and
           returns ONLINE, OFFLINE, TURNED OFF or OUT OF PAPER messages.
            Returns 'test' true if printer status is on-line & ready
              to print.  Otherwise returns 'test' false. }
        var  Status : byte ;  { status register }
        begin
             Status := Port [ BaseAddress + 1 ] ;     { assign status port }
             test := false ;
             msg  := 'Printer is On-Line.                                  ';
             if Status and $90 = $80 then             { test Bit #7,#5 & #4 }
                  msg  :=  'Printer is turned off or cable disconnected.   '
             else if Status and $20 = $20 then               { test Bit #5  }
                  msg  :=  'Printer is out of paper.                        '
             else if Status and $B8 = $98 then     { test Bit #7,#5,#4 & #3 }
                  test :=  true
             else msg  :=  'Printer is off-line.                            '
        end ;
      {---------------------------------------------------------------------}
        procedure Shut_Down_Printer (  y : integer ) ;
        { Accepts -y- as a pointer to the screen.  Continues to display
           error message while counting down to shutdown.  Program will
            halt if error condition is not corrected before time_lapse. }
        var  Start_Time , Elapse_Time : real ;
        begin
             Start_Time  := Current_Sec ;  { Current_Time from unit timer }
             Elapse_Time := 0 ;
             while not Ready and ( Elapse_Time < time_delay ) do begin
                   GotoXY ( 1 , 1 ) ; writeln ( message ) ;
                   write ( time_delay, ' seconds to shutdown.' ) ;
                   Elapse_Time := Current_Sec - Start_Time ;
                   write ( ' [ ', Elapse_Time:2:1 , ' ] ' ) ;  {  time   }
                   PrinterStatus ( message , ready ) ; end ;
             if Elapse_Time >= time_delay then begin
                   GotoXY ( 1 ,  y + 3 ) ;
                   writeln ( 'Printer has been halted due to time lapse.' );
                   close ( f ) ; halt ;  end ;
        end ;
      {---------------------------------------------------------------------}
        procedure Print_Char ( c : char ) ;
        { Accepts and converts 'c' to ordinal value and places it in the
           Data Output Port.  If the printer is not busy then the
             Low Bit #0 of the Control Register is strobed from 1 to 0
              telling the printer that a new byte is in the Data Port.
               Otherwise program is count down to time_lapse shutdown.
                Printer Status Port messages are always displayed. }
        var   x , y   : integer ;
        begin
             x := WhereX ; y := WhereY ;           { store screen position  }
             GotoXY ( 1 , 1 )    ; ClrEol ;        { goto top of screen     }
             writeln ( message ) ; ClrEol ;        { display status message }
             Port [ BaseAddress ] := ord ( c ) ;{puts -c- in the Data Port  }
             delay ( 100 ) ;                   { settle the status register }
             PrinterStatus ( message , ready ) ;     { is the printer ready? }
             if not Ready then Shut_Down_Printer ( y ) ;  { start countdown }
             GotoXY ( x , y ) ;        { continue display where it left off }
             Port [ BaseAddress + 2 ] :=  $0D ; {Strobe Control Bit #0 to 1 }
             Port [ BaseAddress + 2 ] :=  $0C ; {Reset  Control Bit #0 to 0 }
        end ;
      {---------------------------------------------------------------------}

BEGIN     { main }
   repeat
     BaseAddress := MemW [ $0040:$8 ] ;        { port address for DOS LPT1 }
     clrscr ; ch := ' ';                       { initialize char as a blank }
     writeln ( 'This program delays on error conditions before halting.');
     write   ( 'This delay before shutdown is ',time_delay,' seconds.');
     writeln ; writeln ;
     write   ( 'Input filename ( e.g. d:filename.ext ) -> ' ) ;
     readln  ( filename ) ;  clrscr ;
     assign  ( f , filename ) ;   reset ( f ) ;
     PrinterStatus ( message , ready ) ;
     if Ready then begin
        { Initialize port LPT1 for printing by strobing the
           Pulse Bit #2  of the Control Register from 1 to 0 with
            Bit #3 set to 1 and Bit #4 set to 0 ( interrupts disabled ).}
        Port [ BaseAddress + 2 ] :=  $EB ;    { Strobe Control Bit #2 to 1  }
        Port [ BaseAddress + 2 ] :=  $EC ;    { Reset  Control Bit #2 to 0  }
        writeln ( message ) ;                      { display printer status }
        writeln; writeln;                             { two blank lines     }
        read ( f , ch ) ;                             { read char from file }
        while ch <> end_of_file do begin
              Print_Char ( ch ) ;                      { send ch to printer }
              write ( ch ) ;                       { dispaly char on screen }
              read ( f , ch ) ; end ; { while }            { read next char }
        writeln; writeln ;
        write ( 'Enter  -Q- to quit or hit any key to continue --> ' ) ;
        ch := readkey ; end { if }
     else Shut_Down_Printer ( WhereY ) ; { printer not ready start shutdown }
   until ( upcase ( ch ) = 'Q') or not Ready ;
   close ( f ) ;
end.  { main }

