(*----------------------------------------------------------------------*)
(*            Read_Kbd --- Read one character from keyboard             *)
(*----------------------------------------------------------------------*)

PROCEDURE Read_Kbd( VAR Ch: CHAR );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*     Procedure:  Read_Kbd                                             *)
(*                                                                      *)
(*     Purpose:    Reads one character from the keyboard                *)
(*                                                                      *)
(*     Calling Sequence:                                                *)
(*                                                                      *)
(*        Read_Kbd( VAR Ch: CHAR );                                     *)
(*                                                                      *)
(*           Ch  --- Character read                                     *)
(*                                                                      *)
(*     Remarks:                                                         *)
(*                                                                      *)
(*        This routine centralizes single character keyboard reads so   *)
(*        that time-slicing control for multitaskers is more easily     *)
(*        centralized.  In this particular implementation, the time     *)
(*        spent waiting for a keyboard entry is donated to the other    *)
(*        partitions.                                                   *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

BEGIN (* Read_Kbd *)

   WHILE ( NOT KeyPressed ) DO
      GiveUpTime( 2 );

   Ch := ReadKey;

END   (* Read_Kbd *);
