UNIT PibMTask;

(*----------------------------------------------------------------------*)
(*            PibMTask --- Multitasking interfaces for Turbo Pascal     *)
(*----------------------------------------------------------------------*)
(*                                                                      *)
(*  Author:   Philip R. Burns                                           *)
(*                                                                      *)
(*  Version:  1.2   June, 1988.                                         *)
(*                                                                      *)
(*  Overview: This unit provides Turbo Pascal interfaces to several of  *)
(*            the most popular multitasking programs for DOS:           *)
(*                                                                      *)
(*               - DesqView from QuarterDeck                            *)
(*               - TaskView and OmniView from Sunny Hill Software       *)
(*               - TopView from IBM                                     *)
(*               - DoubleDos from SoftLogic                             *)
(*                                                                      *)
(*            Because MicroSoft Windows will emulate TopView, these     *)
(*            routines are also useful for Windows (in text mode only). *)
(*                                                                      *)
(*            The include file PIBMDOS.PAS contains the actual          *)
(*            interface routines.                                       *)
(*                                                                      *)
(*            Global variables of importance:                           *)
(*                                                                      *)
(*               Virtual_Screen      --- address of real screen if no   *)
(*                                       multitasker running, else      *)
(*                                       address of virtual screen.     *)
(*               MultiTasker         --- which multitasker is active.   *)
(*               TimeSharingActive   --- TRUE if multitasker is active. *)
(*               Wait_For_Retrace    --- Set this TRUE if your color    *)
(*                                       graphics card produces snow    *)
(*                                       when screen memory is accessed *)
(*                                       (e.g., set TRUE for IBM's CGA  *)
(*                                       but FALSE for Zeniths and      *)
(*                                       Compaqs, among others).        *)
(*               Write_Screen_Memory --- TRUE to write directly to      *)
(*                                       screen memory -- either the    *)
(*                                       genuine screen memory or the   *)
(*                                       virtual buffer for a multi-    *)
(*                                       tasker.  FALSE to use the BIOS *)
(*                                       instead.                       *)
(*            Routines:                                                 *)
(*                                                                      *)
(*               IsTimeSharingActive --- Determines which multitasker,  *)
(*                                       if any, is active, and sets    *)
(*                                       the virtual buffer address in  *)
(*                                       "Virtual_Screen."              *)
(*               TurnOnTimeSharing   --- Allows time slicing to go on.  *)
(*                                       You may wish to start/stop     *)
(*                                       time slicing when accessing    *)
(*                                       critical code.                 *)
(*               TurnOffTimeSharing  --- Turns off time slicing.        *)
(*               GiveUpTime          --- Gives up test of this program's*)
(*                                       current time slice for use by  *)
(*                                       other programs.                *)
(*               Sync_Screen         --- Issues TopView synchronization *)
(*                                       call required by TopView and   *)
(*                                       Windows when the virtual buffer*)
(*                                       is updated.                    *)
(*               Sync_Entire_Screen  --- Issues TopView synchronization *)
(*                                       call for entire screen.        *)
(*                                                                      *)
(*            I would appreciate it if anyone familiar with the other   *)
(*            multitaskers for which no interface is provided would     *)
(*            add the relevant code and upload a corrected copy         *)
(*            for all of us to learn from.                              *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

INTERFACE

USES
   Dos, Crt, GlobScrn;

(*----------------------------------------------------------------------*)
(*                       Multitasker definitions                        *)
(*----------------------------------------------------------------------*)

TYPE
   MultiTaskerType     = ( MultiTasker_None, DoubleDos, DesqView, TopView,
                           MSWindows, APXCore, EZDosIt, Concurrent_DOS,
                           TaskView, MultiLink, Other );

VAR
   TimeSharingActive : BOOLEAN     (* TRUE if multitasker active        *);

                                   (* Which multitasker active          *)
   MultiTasker       : MultiTaskerType;

   Virtual_Screen    : Screen_Ptr  (* Alternate display buffer address *);

(* EXPORTS *)

   FUNCTION  IsTimeSharingActive : BOOLEAN;
   PROCEDURE TurnOnTimeSharing;
   PROCEDURE TurnOffTimeSharing;
   PROCEDURE GiveUpTime( NSlices : INTEGER );
   PROCEDURE Sync_Screen( S_Pos: INTEGER; NChars : INTEGER );
   PROCEDURE Sync_Entire_Screen;

IMPLEMENTATION
                                   (* Ensure multitasking defined       *)
{$DEFINE MTASK}
                                   (* Multitasker interface routines    *)
{$I PIBMDOS.PAS  }

END   (* PibMTask *).
