program SHOWCGA;

(* Sample implementation of PCX.TPU for CGA. You need to have the
   Turbo .BGI files in the current directory, or change Initgraph.
   Enter a valid filename (without extension) on the command line
   or, if you're running under Turbo, in the Parameters box.

   For 4-color images in the standard colors, just change Grmode to Cgac1 *)

uses GRAPH, DOS, CRT, PCX;

var   grdriver, grmode: integer;
      textpage0: byte absolute $b800:0000;
      page0: ^byte;
      textsave: pointer;
      cursorx, cursory: byte;

begin
clrscr;
writeln('This is a text screen, which we will save and restore.');
writeln;
write('Strike any key. ');
cursorx:= wherex; cursory:= wherey;
page0:= @textpage0;
getmem(textsave, 4000);
move(page0^, textsave^, 4000);               { Save text screen }
repeat until readkey <> #1;
pcxfilename:= paramstr(1) + '.PCX';
grdriver:= cga; grmode:= cgahi;              { 2-color 640x200 format }
initgraph(grdriver, grmode, '');
read_pcx_file(grdriver, pcxfilename);
if file_error then
begin
  closegraph;
  writeln('File ', fexpand(pcxfilename), ' not found.');
  halt;
end;
move(buff1^, screenbuff1, 8000);             { Display the image }
move(buff2^, screenbuff2, 8000);
repeat until readkey <> #1;
closegraph;
move(textsave^, page0^, 4000);               { Restore text screen }
gotoxy(cursorx, cursory);
freemem(textsave, 4000);
repeat until readkey <> #1;
clrscr;
end.
