(*********************************************)
(*                                           *)
(*          SIMPLE.PAS      Jan 92           *)
(*                                           *)
(*  SIMPLE is provided as the simpliest      *)
(*  possible terminal program using PCL4P    *)
(*                                           *)
(*  This program is donated to the Public    *)
(*  Domain by MarshallSoft Computing, Inc.   *)
(*  It is provided as an example of the use  *)
(*  of the Personal Communications Library.  *)
(*                                           *)
(*********************************************)


program simple;
uses crt, PCL4P;

const
   BaudCode = Baud2400;  (* Choose baud rate: Baud300 to Baud115200 *)
var
   Buffer  : array[0..1024] of Char;
   RetCode : Integer;
   Byte : Char;
   i    : Integer;
   Port : Integer;
   ResetFlag : Boolean;

procedure SayError( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then RetCode := SioError( Code )
   else if (Code and (FramingError or ParityError or OverrunError)) <> 0 then
      begin (* Port Error *)
         if (Code and FramingError) <> 0 then writeln('Framing Error');
         if (Code and ParityError)  <> 0 then writeln('Parity Error');
         if (Code and OverrunError) <> 0 then writeln('Overrun Error')
      end
end;

procedure MyHalt( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then SayError( Code );
   if ResetFlag then RetCode := SioDone(Port);
   writeln('*** HALTING ***');
   Halt;
end;

begin   (* main program *)
   ResetFlag := FALSE;
   (* fetch PORT # from command line *)
   if ParamCount <> 1 then
      begin
         writeln('USAGE: "SIMPLE <port>" where port = 1,2,3, or 4');
         halt;
      end;
   Val( ParamStr(1),Port, RetCode );
   if RetCode <> 0 then
      begin
         writeln('Port must be 1 to 4');
         Halt;
      end;
   (* COM1 = 0, COM2 = 1, COM3 = 2, COM4 = 3 *)
   Port := Port - 1;
   if (Port<COM1) or (Port>COM4) then
      begin
         writeln('Port must be 1 to 4');
         Halt
      end;
   (* setup 1K receive buffer *)
   RetCode := SioRxBuf(Port, Ofs(Buffer), Seg(Buffer), Size1024);
   if RetCode < 0 then MyHalt( RetCode );
   (* reset port *)
   RetCode := SioReset(Port,BaudCode);
   (* if error then try one more time *)
   if RetCode <> 0 then RetCode := SioReset(Port,BaudCode);
   (* Was port reset ? *)
   if RetCode <> 0 then
     begin
        writeln('Cannot reset COM',Port+1);
        MyHalt( RetCode );
     end;
   (* Port successfully reset *)
   writeln('Reset successfull');
   ResetFlag := TRUE;
   (* specify parity, # stop bits, and word length for port *)
   RetCode := SioParms(Port, NoParity, OneStopBit, WordLength8);
   if RetCode < 0 then MyHalt( RetCode );
   writeln; writeln(' SIMPLE 1.0: COM',1+Port,': 2400 Baud: Type ESC to quit');
   RetCode := SioRxFlush(Port);
   if RetCode < 0 then MyHalt( RetCode );
   (* begin terminal loop *)
   writeln('Enter terminal loop');
   while TRUE do
      begin
         (* did user press Ctrl-BREAK ? *)
         if SioBrkKey then
            begin
               writeln('User typed Ctl-BREAK');
               RetCode := SioDone(Port);
               Halt;
            end;
         (* anything incoming over serial port ? *)
         RetCode := SioGetc(Port,0);
         if RetCode < -1 then MyHalt( RetCode );
         if RetCode > -1 then Write( chr(RetCode) );
         (* has user pressed keyboard ? *)
         if KeyPressed then
            begin
               (* read keyboard *)
               Byte := ReadKey;
               (* quit if user types ESC *)
               if Byte = chr($1b) then
                  begin
                     writeln('User typed ESC');
                     RetCode := SioDone(Port);
                     Halt;
                  end;
               (* send out over serial line *)
               RetCode := SioPutc(Port, Byte );
               if RetCode < 0 then MyHalt( RetCode );
            end
      end
end.
