{ Fido Pascal Conference  PASCAL 
Msg  : 216 of 228
From : Warren Zatwarniski                  1:140/111.0          14 Jul 93  22:45
To   : All
Subj : (1/3) NAP_DRAW.PAS
}
Unit NAP_DRAW;

Interface

Uses
    Bits, BIN_UNIT ;

    Type
        NAPCoord = String;

TYPE
   NAPBits = Record                     {Record to hold the 3 seperate parts}
                   P1, P2, P3 : Byte    {of a Byte. P1 contains 2 bits, and }
            end;                        {the P2 & P3 contain 3 bits.        }
   XYType = Record
                X, Y : Byte
             End;


Const
     PointSetAbs = Chr(164);
     PointSetRel = Chr(165);
     PointAbs    = Chr(166);
     PointRel    = Chr(167);

     SetPolyFill = Chr(183);
     PolyFill    = Chr(181);

     LineAbs     = Chr(168);
     LineRel     = Chr(169);
     SetLineAbs  = Chr(170);
     SetLineRel  = Chr(171);

     ArcOutline  = Chr(172);
     ArcFilled   = Chr(173);
     SetArcOutline = Chr(174);
     SetArcFilled  = Chr(175);

     RectO         = Chr(176);
     RectF         = Chr(177);
     SetRectO      = Chr(178);
     SetRectF      = Chr(179);

     NAPSetColor = Chr(188);


VAR
   XColor : Word;                         {Set to max number of colors}
   LMO    : ShortInt;                     {Length of Multivalue Operands  }
   LSO    : ShortInt;                     {Length of Single-Value Operands}
   PelSize : XYType;
   CharSpace, CharPath, CharRot, CursStyle, MoveAttr, RowSpace : Byte;



Function N_Point (Xcoord, Ycoord : Integer) : String;
Function N_SelectColor (Color : Byte) : String;
Function N_SetColor(Green, Red, Blue : Real) : String;
Function N_Domain : String;
Function N_Reset (Color, Mode : Byte; D, T, F, U, X, M, R : Boolean) : String;
Function N_Text (XSize,YSize : Byte) : String;


Procedure SeperateBits (Coord : Byte; VAR Pbits : NAPBits);


Implementation

Procedure SeperateBits ( Coord : Byte ;
                        VAR PBits : NAPBits);
Var
   TEMP : Byte;

Begin
     With PBits DO
        Begin
           P1 := Coord shr 6;
           P2 := (Coord - (P1 Shl 6)) Shr 3;
           P3 := Coord - ((P1 Shl 6) + (P2 shl 3));
        End;
End;

Function N_Point (Xcoord, Ycoord : Integer ) : NAPCoord;
VAR
   Xbits, Ybits : NAPBits;
   XSign, YSign : Byte;
Begin
     XSign := 0;
     YSign := 0;
     If Xcoord < 0 Then                            { Is X Negative? }
        Begin
           Xsign := 1;
           Xcoord := (255 - Abs(Xcoord)) + 1
        end;
     If Ycoord < 0 Then                           { Is Y Negative? }
        Begin
           YSign := 1;
           YCoord := (255 - Abs(YCoord)) + 1
        end;
     SeperateBits(Xcoord, Xbits);
     SeperateBits(Ycoord, Ybits);
     N_Point := Chr( (192) + (XSign SHL 5) + (Xbits.P1 Shl 3) + (YSign SHL 2) +
(Ybits.P1) ) +
                Chr( (192) + (Xbits.P2 Shl 3) + (Ybits.P2) ) +
                Chr( (192) + (Xbits.P3 shl 3) + (Ybits.P3) );
End;


Function N_SelectColor (Color: Byte) : String;

VAR
   Temp : String;
   TByte : Byte;
Begin
     Temp := '';
     Temp := Chr(128 + 62);
     IF XColor <= 2 Then
        Temp := Temp + Chr(192 + (Color Shl 5))
        Else If XColor <= 4 Then
           Temp := Temp + Chr(192 + (Color Shl 4))
           Else If Xcolor <= 8 Then
              Temp := Temp + Chr(192 + (Color SHL 3))
              Else IF XColor <= 16 Then
                 Temp := Temp + Chr(192 + (Color SHL 2))
                 Else IF XColor <= 32 Then
                    Temp := Temp + Chr(192 + (Color SHL 1))
                    Else IF Xcolor <= 64 Then
                       Temp := Temp + Chr(192 + Color)
                       Else IF Xcolor <= 128 Then
                          Begin
                             TByte := ( (Color SHR 1) SHL 1);
                             Temp := Temp + Chr(192 + (Color SHR 1) ) ;
                             Temp := Temp + Chr(192 + ( (Color - TByte) SHL 5) 
);
                          End
                          Else
                             Begin
                                TByte := ( Color SHR 2);
                                Tbyte := TByte SHL 2 ;
                                Temp := Temp + Chr(192 + (Color SHR 2) );
                                Temp := Temp + Chr(192 + ( (Color - Tbyte) SHL 
4) );
                             End;
     N_SelectColor := Temp
End;


Function N_SetColor(Green, Red, Blue : Real) : String;

VAR
   Loop, Temp : Byte;
   TempReal : Real;
   WorkStr : String;
   IntRed, IntGreen, IntBlue : Integer;
   Dec1Red, Dec2Red, Dec3Red,
   Dec1Green, Dec2Green, Dec3Green,
   Dec1Blue, Dec2Blue, Dec3Blue : Byte;

Function MoveOver(WorkWith : Real) : Real;
Begin
     MoveOver := ( (WorkWith * 2) - (Trunc(WorkWith * 2)));
End;



Begin
     IntRed := Trunc(Red);
     IntGreen := Trunc(Green);
     IntBlue := Trunc(Blue);
     TempReal := (Red - IntRed);                {Dec1Red equals the first  }
     Dec1Red := Trunc(TempReal * 2);            {decimal bit in the Red    }
       TempReal := MoveOver(TempReal);          {value                     }
       Dec2Red := Trunc(TempReal * 2);          {Dec2Red is equal to the   }
         TempReal := MoveOver(TempReal);        {Second decimal bit in the }
         Dec3Red := Trunc(TempReal * 2);        {red Value and so on       }
     TempReal := (Green - IntGreen);            {could use some serious    }
     Dec1Green := Trunc(TempReal * 2);          {rewrite here for faster   }
       TempReal := MoveOver(TempReal);          {speed - But this works :> }
       Dec2Green := Trunc(TempReal * 2);
         TempReal := MoveOver(TempReal);
         Dec3Green := Trunc(TempReal * 2);
     TempReal := (Blue - IntBlue);
     Dec1Blue := Trunc(TempReal * 2);
       TempReal := MoveOver(TempReal);
       Dec2Blue := Trunc(TempReal * 2);
         TempReal := MoveOver(TempReal);
         Dec3Blue := Trunc(TempReal * 2);
     WorkStr := '';
     WorkStr := Chr(192+
                           ((IntGreen SHR 2) SHL 5) +
                           ((IntRed   SHR 2) SHL 4) +
                           ((IntBlue  SHR 2) SHL 3) +
                           (((IntGreen - ((IntGreen SHR 2) SHL 2)) SHR 1) SHL
2) +
                           (((IntRed -   ((IntRed   SHR 2) SHL 2)) SHR 1) SHL
1) +
                           (( IntBlue -  ((IntBlue  SHR 2) SHL 2)) SHR 1)
                           );
     WorkStr := WorkStr + Chr(192 +
                           ((IntGreen - ((IntGreen SHR 1) SHL 1)) SHL 5) +
                           ((IntRed   - ((IntRed   SHR 1) SHL 1)) SHL 4) +
                           ((IntBlue  - ((IntBlue  SHR 1) SHL 1)) SHL 3) +
                           (Dec1Green SHL 2) +
                           (Dec1Red   SHL 1) +
                           (Dec1Blue       )
                          );
     WorkStr := WorkStr + Chr(192 +
                           (Dec2Green SHL 5) +
                           (Dec2Red   SHL 4) +
                           (Dec2Blue  SHL 3) +
                           (Dec3Green SHL 2) +
                           (Dec3Red   SHL 1) +
                           (Dec3Blue       )
                          );
     N_SetColor := WorkStr
End;

Function N_Domain : String;
VAR
   TempS : String;
   TempX, TempY : Byte ;
   XBits, YBits : NAPBits;

Begin
     TempS := Chr(161)+Chr(192+( (LMO - 1) SHL 2) + (LSO - 1) );
     Case LMO of
          1 : TempS := TempS + Chr(192 + (PelSize.X SHL 3) + (PelSize.Y));
          2 : Begin
                 TempX := (PelSize.X SHR 3) ;
                 TempY := (PelSize.Y SHR 3) ;
                 TempS := TempS + Chr(192 + (TempX SHL 3) + TempY) ;
                 TempS := TempS + Chr(192 +
                                     ( ( (TempX SHL 3) - PelSize.X) SHL 3) +
                                     ( ( (TempY SHL 3) - PelSize.Y) ) )
              End;
          3 : Begin
                 SeperateBits(PelSize.X, Xbits);
                 SeperateBits(PelSize.Y, YBits);
                 TempS := TempS + Chr(192 + (Xbits.P1 SHL 3) + YBits.P1) +
                                  Chr(192 + (Xbits.P2 SHL 3) + YBits.P2) +
                                  Chr(192 + (XBits.P3 SHL 3) + YBits.P3);
              End;
     End;
     N_Domain := TempS;
End;


Function N_Reset (Color, Mode : Byte;
                D, T, F, U, X, M, R: Boolean) : String;
                                                {Color: 1..7, Mode 1..3    }
                                                {D - Domain  T - Text      }
                                                {F - Blink   U - User Fiels}
                                                {X - Texture M - Macros    }
                                                {R - DRCS                  }
Begin
     N_Reset := Chr(160) +
              Chr(192 + (Color SHL 3) + (Mode SHL 1) + Ord(D)) +
              Chr(192 + (Ord(R) SHL 5) + (Ord(M) SHL 4) + (Ord(X) SHL 3) +
                        (ORD(U) SHL 2) + (Ord(F) SHL 1) + Ord(T));
End;

Function N_Text (XSize, YSize: Byte) : String;

Var
   XBits, YBits : NAPBits;

Begin
     SeperateBits ( XSize, XBits);
     SeperateBits ( YSize, YBits);
     N_Text := Chr(162) +
               Chr(192 + (CharSpace SHL 4) + (CharPath SHL 2) + CharRot) +
               Chr(192 + (CursStyle SHL 4) + (MoveAttr SHL 2) + RowSpace) +
               Chr(192 + (Xbits.P1 SHL 3) + YBits.P1) +
               Chr(192 + (Xbits.P2 SHL 3) + YBits.P2) +
               Chr(192 + (Xbits.P3 SHL 3) + YBits.P3);
End;





Begin
   Xcolor := 16;
   LMO    := 3;
   LSO    := 1;
   PelSize.X := 1;
   PelSize.Y := 1;
   CharSpace := 0;
   CharPath := 0;
   CharRot := 0;
   CursStyle := 0;
   MoveAttr := 0;
   RowSpace := 0;
end.