{ Fido Pascal Conference  PASCAL 
Msg  : 272 of 278
From : BRIAN PAPE                          1:2250/26.0          24 Jul 93  17:42
To   : ALL
Subj : Input Line Source Code

Code by Brian Pape. As of today (7-24-93), it is in the public domain; for
personal use you may do whatever you like.  However, if is to be included
in a library or collection of code, mention my name as being the code's
source, and DO NOT (a la Ecolib) distribute it with commercial software
illegally!}

{ Written by Brian Pape, (c) Copyright 1992.
  Note: This code is an attempt at an input line.  It probably still needs
  modifications.

  This procedure will get input from the user.
  s- the string returned from the procedure
  hidden- this is if you want the input shown as a different character
          than what is typed (for instance, for a password)
  hc- the character you want displayed if HIDDEN is true
  x1,y1- the x,y coordinates to display the input line at (1 based)
  len- the max length of the input line
  strlen- the max length of the input string
  txt_at- the color attribute (same format as TEXTATTR built into the CRT
          unit (high 4 bits, bckgnd, low 4 bits, foreground))
  scrl_at- the attribute used for the scroller characters showing that there
           is additional text on either side of the displayed text
  inperr- returns a non-zero code if the input line is aborted with an
          ESC character }
procedure getinput(var s:string;hidden:boolean;hc:char;
                   x1,y1,len,strlen,txt_at,scrl_at:byte;
                   var inperr:integer);
var
  tmp,
  fill : string;
  curlen : byte absolute s;
  strptr : byte;
  done : boolean;
  c : split;
  i : byte;
begin
  fillchar(fill,sizeof(fill),32);
  fill[0] := chr(len);
  if x1+len+1 > 80 then exit;
  if x1-1 < 1 then exit;
  fillchar(s,sizeof(s),32);
  curlen := 0;
  strptr := 1;
  done := false;
  repeat
    if getinput_debug then
      begin
        gotoxy(1,1);
        write('STRPTR=',strptr:3,' CURLEN=',curlen:3,' LEN=',len:3,
              ' STRLEN=',strlen:3);
      end;  { if getinput_debug }
    fasterwrite(fill,x1,y1,txt_at);
    if strptr < len then
      if curlen < len then
        begin
          tmp := copy(s,1,curlen);
          gotoxy(x1+strptr-1,y1);
        end  { if }
      else
        begin
          tmp := copy(s,1,len-1);
          gotoxy(x1+strptr-1,y1);
        end  { else }
    else
      begin
        tmp := copy(s,strptr-len+1,len-1);
        gotoxy(x1+len-1,y1);
      end;  { else }
    if hidden then
      fillchar(tmp[1],length(tmp),hc);
    fasterwrite(tmp,x1,y1,txt_at);
    getkey16(c);
    case c.char of
      #0:case c.scan of
           #$4B:if strptr > 1 then dec(strptr);
           #$4D:if strptr <= strlen then inc(strptr);
           #$47:strptr := 1;  { HOME }
           #$4F:
             begin
               i := strlen;
               while s[i] = ' ' do
                 dec(i);
               strptr := i+1;
             end;  { END }
           #$53:
             begin
               delete(s,strptr,1);
               tmp := s;
               fillchar(s,sizeof(s),32);
               s := tmp;
             end;  { DEL }
         end;  { case }
      ' '..'~':if (curlen < strlen) and (strptr <= strlen) then
        begin
          insert(c.char,s,strptr);
          inc(strptr);
        end;  { }
      #8:
        if strptr > 1 then
        begin
          delete(s,strptr-1,1);
          dec(strptr);
        end;  { #8 }
      #13:done := true;
      #27:
        begin
          s := '';
          done := true;
        end;  { #27 }
    end;  { case }

  until done;
end;  { getinput }