{ Fido Pascal Conference  PASCAL 
Msg  : 263 of 335
From : Todd Holmes                         1:152/5.0            29 Jun 93  08:52
To   : Dj Murdoch
Subj : Unit Cstr: Nul term strings for streams
}
Program CstrTest;  {_Tested !!}
{Demostrates the use of CStr.Pas}

Uses Objects,Cstr;
Var
   Stream: PStream;
   I: integer;
   PS: String;

Procedure PrintStream(S:PStream);
{Prints all nul strings in the stream, assumes that the stream contains
 valid data}
 begin
  Repeat
   Writeln(LoadPStr(S^)); {Load a Cstr and converts it to a Pas string}
  Until S^.GetPos = S^.GetSize;
 end;

Function InitStream:PStream;
{Shows how easy it is to copy a file to EMS if available}

Var Buf,EMS: PStream;
 begin
   Buf := New(PBufStream,Init('Test.txt',stOpenRead,512)); {Open BufStream}
   Ems := New(PEmsStream,Init(Buf^.GetSize,Buf^.GetSize)); {Open EMSstream}
   If Ems^.Status = stOk then begin  {if status <> ok then probly no ems}
     Writeln('Using EMS.............');
     Ems^.CopyFrom(Buf^,Buf^.GetSize); {Copy entire file to ems}
     Ems^.Seek(0);                     {Reset Ems}
     Dispose(Buf,Done);                {Get rid of buf}
     Buf := Ems;
    end
   Else begin
     Writeln('Bummer..time to upgrade?... Using Dos.......');
     Dispose(Ems,Done);
    end;

   InitStream := Buf; {note: this could be EMS or Buf, isn't OOP great!}
 end;

begin
  {CStrBuff has already create by the unit}
  {Lets build our test file}
  Stream:= New(PBufStream,Init('Test.txt',stCreate,512));
  For I := 1 to 10 do begin
    Str(I,PS);   {Converts Integer to String}
    StorePstr(Stream^,PS); {Stores Pas string on the stream as a C String}
   end;
 Dispose(Stream,Done); {Shuts down the stream}

 Stream := InitStream;      {Sets stream up in EMS if Available}
 PrintStream(Stream);       {Print contents of stream}

 InitCStrBuff(MaxCStrLen);  {change CStrBuff to 64k}
 Stream^.Seek(0);           {Reset Stream}
 Writeln;
 Writeln('changed Cstrbuff size to : ',MaxStrLen);
 Writeln;
 PrintStream(Stream);
 Dispose(Stream,Done);
 DoneCStrBuff; {Remember to kill the buffer}
end.