{ Fido Pascal Conference  PASCAL 
Msg  : 262 of 335
From : Todd Holmes                         1:152/5.0            29 Jun 93  08:50
To   : Dj Murdoch
Subj : Unit Cstr: Nul term strings for streams
}
Unit Cstr;

{Unit CStr  Ver .02
 by Todd Holmes
 Created: 6/21/93

 Tested

 Cstr is a unit to suppliment the writing and reading of Nul terminating
 strings to and from Streams. Cstr also offers conversion from Pascal strings
 to Nul term Strings. If you note a bug, or even another(better) way of doing
 what this program does, please drop me a note.

 Last Modified: 6/28/93
   6/28/93: From suggest given by DJ Murdoch
            Added a buffer to prevent needless flushing of the stream during
             seek procedures, rewrote LoadCStr, this increased execution speed.
            Changed varible MaxLen to MaxStrLen to preserved naming
             conventions.

 Future Improvements: Error checking needs to be expanded
                      Turn it into an Object}

{$O+,X+,F+}         {Allow unit to be overlaid, extented syntax (required for
                    using the Strings Unit, Force Far calls}
Interface

Uses Strings, Objects;

Const

  MaxCstrLen = 65528; {max amount in bytes that can be allocated on the heap}
  MaxPstrLen = 256;   {Max length of a pascal style string}

Var

   MaxStrLen: Word; {Defines the maximum size of a nul string that can
                    be read from a stream. The unit sets this to MaxPStrLen
                    by default, you may set this to any value that is not
                    larger then MaxCstrLen}

   CStrBuff:PChar; {Points to the beginning of the buffer}

   CStrBuff_Seg,
   CStrBuff_Ofs: Word; {Points to the actual data}

Procedure InitCStrBuff(Size:Word);  {Ver .02}
{Creates a buffer of Size and sets it's location in CStrBuff, Sets MaxStrLen
 to Size. If there is not enough mem, sets CstrBuff to nil. If CstrBuff is
 not nil, then InitCstrBuf will despose of CstrBuff.}

Procedure DoneCStrBuff;  {Ver .02}
{if CstrBuff is not nil, desposes of the buffer created by InitCstrBuf.
 DoneCstrBuf uses MaxStrLen to determine how much memory to free. Sets
 CStrBuff to nil}

Procedure StoreCstr( Var S:TStream; Cstr: PChar);
{Writes Nul terminating String to a stream}

Procedure StorePstr(VAr S:TStream; PStr: STring);
{Converts a Pas string to a nul term str and writes to a stream}

Function LoadCStr(Var S:TStream): PChar; {Ver .02}
{Loads a Nul term String from a stream, assumes the stream is positioned
 at the start of the string to be read in. Will truncate the string if
 string is greater then MaxStrLen}

Function LoadPStr(Var S: TStream):String; {Ver .02}
{Loads a Nul term string and converts it to a Pascal string}

Implementation

Procedure InitCstrBuff(Size:Word);
 begin
   DoneCStrBuff; {Dispose of old buffer, and sets CstrBuff to Nil}
   GetMem(CstrBuff,Size);         {Allocate Resizable Array}
   MaxStrLen := Size;             {Need to preserve this to dispose of array}
   CStrBuff_Seg := Seg(CStrBuff^);{For Indexing CStrbuf}
   CStrBuff_Ofs := Ofs(CStrBuff^);
 end;

Procedure DoneCstrBuff;
 begin
  If CstrBuff <> Nil then begin
    FreeMem(CstrBuff,MaxStrLen); {Disposes of Buffer}
    CStrBuff := Nil;
  end;
 end;

Procedure StoreCstr( Var S:TStream; Cstr: PChar);
{Writes Nul terminating String to a stream}
 begin
   S.Write(Cstr^,Strlen(Cstr)+1);  {StrLen: String Unit}
 end;

Procedure StorePstr(Var S:TStream; PStr: String);
var
 Cstr: PChar;
 begin
   Getmem(Cstr,Length(Pstr)+1);   {Allocate memory on the heap}
   StrPCopy(CStr,Pstr);           {Strings Unit: Converts Pstr to CStr}
   StoreCstr(S,Cstr);             {Stores the CStr}
   FreeMem(Cstr,Length(Pstr)+1);  {Frees up the Allocated memory}
 end;

Function LoadCStr(Var S:TStream): PChar;
var
 Index: Word;
 Buff_Head:PChar;   {Head: as in read/write head}
begin
  Index := 0;
  Repeat                        {Scan for end of string, (nul term char: #0)}
    Buff_Head := Ptr(CStrBuff_Seg,
                   CStrBuff_Ofs + Index); {Index The buffer}
    S.Read(Buff_Head^,1);                  {Read straight to buffer}
    Inc(Index);
  Until (Buff_Head^ = #0) or (Index = MaxStrLen) or (S.Status <> StOk);
  If Index = MaxStrLen then Buff_Head := #0; {Truncate to MaxStrLen}
  LoadCstr := StrNew(CStrBuff);            {Strings Unit: Makes copy of
                                            of String in CstrBuff}
end; {LoadCstr}

Function LoadPStr(Var S: TStream):String;
{Loads a Nul term string and converts it to a Pascal string}
var
 CStr : PChar;
 begin
   CStr := LoadCStr(S);           {Loads a nul term string}
   LoadPStr := StrPas(CStr); {Strings Unit: Converts CStr to a Pascal String}
   StrDispose(CStr);         {Strings Unit: Dispose of a Nul term string}
 end;

begin
  CStrBuff := Nil;
  InitCStrBuff(MaxPStrLen); {Since the main purpose of this unit is to
                            convert Pas strings to/ from C strings, the
                            unit sets up the buffer for pascal strings.
                            at anytime you may change the size of the buffer
                            (and there by change the size of MaxStrLen) to
                            any size not greater then MaxCStrLen}
end.