(* Fido Pascal Conference  PASCAL 
Msg  : 295 of 370
From : Keld R. Hansen                      2:234/10.0           25 Jun 93  21:36
To   : Bryce Ostenson                      1:282/4028.0
Subj : Stuffing Keyboard Buffer

In a message dated 10 Jun 93, Bryce Ostenson (1:282/4028.0) wrote:

 > You don't need to know assembler, just to understand how to call an
 > interrupt from pascal. It's simple... [...] Begin        Regs.AH := $05;  {
 > function $05 of interrupt $16 }        Regs.CH := ScanCode;        Regs.CL
 > := AsciiCode;        Intr($16,Regs);        If Regs.AL = 0 then StuffKey :=
 > True else StuffKey := False; End;

And this one will *only* work on ATs and XTs after a certain date! A universal
routine follows:*)

PROCEDURE PokeKey; NEAR; ASSEMBLER;
  ASM
                PUSH    AX
                PUSH    BX
                PUSH    CX
                PUSH    ES
                MOV     CX,AX
                {$IFDEF DPMI }
                        MOV     AX,0900h
                        INT     31h
                        PUSH    AX
                {$ELSE  }
                        PUSHF
                        CLI
                {$ENDIF }
                MOV     AX,SEG Seg0040
                MOV     ES,AX
                MOV     ES,ES:Seg0040
                MOV     BX,ES:[001Ch]
                MOV     AX,BX
                INC     AX
                INC     AX
                CMP     AX,ES:[0082h]
                JNE     @NoWrap
                MOV     AX,ES:[0080h]
    @NoWrap:    CMP     AX,ES:[001Ah]
                JE      @Ovflw
                MOV     ES:[001Ch],AX
                MOV     ES:[BX],CX
    @Ovflw:     {$IFDEF DPMI }
                        POP     AX
                        INT     31h
                {$ELSE  }
                        POPF
                {$ENDIF }
                POP     ES
                POP     CX
                POP     BX
                POP     AX
  END;

PROCEDURE PutKeyInKbdBuf(Key : WORD); ASSEMBLER;
  ASM
                MOV     AX,Key
                CALL    PokeKey
  END;

PROCEDURE PutCharInKbdBuf(C : CHAR); ASSEMBLER;
  ASM
                XOR     AH,AH
                MOV     AL,C
                CALL    PokeKey
  END;

PROCEDURE PutStrInKbdBuf(CONST S : STRING); ASSEMBLER;
  ASM
                PUSH    DS
                LDS     SI,S
                CLD
                XOR     AH,AH
                LODSB
                MOV     CX,AX
                JCXZ    @OUT
    @LOOP:      LODSB
                CALL    PokeKey
                LOOP    @LOOP
    @OUT:       POP     DS
  END;

PROCEDURE ClearKbdBuf; ASSEMBLER;
  ASM
                MOV     ES,Seg0040
                MOV     AX,ES:[001Ah]
                MOV     ES:[001Ch],AX
  END;

And it will even work with keyboard extenders if these extenders conform to the
BIOS specification (unlike a lot of other keyboard stuffers I have seen in my
time...)