{ Fido Pascal Conference  PASCAL 
Msg  : 426 of 457
From : Brian Swanson                       1:123/419.0          08 Jul 93  12:14
To   : Justin Shirk
Subj : EMSI/UUCICO

 > Does anyone have a working EMSI program written in
 > Pascal that they could
 > post?

I have written a small EMSI program, it's not very efficient, but it gives you
an idea of how things work.  I just posted the CRC32 unit in another message,
so look at the messages right before this one to get those procedures...}

Program EMSI;
Uses Crt,Dos,CRC_32;
Const
   CR=#13;
   Ident='**';
   Port = 1;
   BaudRate = 38400;

Var
  S  : String;
  C  : Char;
  InKey,
  OutKey : Char;
  Once : Boolean;

Function Hexn(B: Byte) : Char;
Begin
  B:=B and 15;
  If B > 9 then inc(b,7);
  hexn:=chr(B+48);
End;

Function HexB(B: Byte): String;
Begin
  HexB:=HexN(b shr 4) + hexn(b);
End;

Function HexW(W: Word): String;
Begin
  HexW:=HexB(W Shr 8) + HexB(W);
End;

Function HexL(L : LongInt): String;
Begin
  HexL:=HexW(L Shr 16) + HexW(L);
End;

Function CRC16(S : String) : Word;

var
  Sl                       : Byte Absolute S;
  Count1                   : Byte;
  Count2                   : Byte;

  CRC                      : LongInt;

begin
  CRC := 0;

  For Count1 := 1 To Sl Do
  Begin
    CRC := (CRC XOR ( Ord(S[Count1]) SHL 8));
    For Count2 := 1 To 8 Do
      If (CRC And $8000) > 0 Then
        CRC:=((CRC Shl 1) XOR $1021)
      Else
        CRC:=(CRC Shl 1);
  End;
  CRC16 :=(CRC And $FFFF);
End;

Procedure SendChar(C : Char);
Begin
    TransmitChar(Port,C);
End;

Procedure Send(S : String);
Var
  X : Integer;

Begin
  For X:=1 to Length(s) Do
    TransmitChar(Port,S[x]);
End;

Procedure SendLn( S : String);
Var
  x : Integer;
Begin
  For X:=1 to Length(S) Do
    TransmitChar(Port,S[x]);
  TransmitChar(Port,CR);
End;

Procedure Tipe(s : String);
Begin
  TextColor(14);
  WriteLn;
  WriteLn(S);
  TextColor(15);
End;

Procedure SendEMSI(a : String);
Var
  C : Word;
  H,
  S : String;

Begin
  S:='EMSI_' + A;
  C:=CRC16(S);
  H:=HexW(C);
  Send(IDENT + S);
  SendLn(H);
End;

Procedure SendHandshake;
Var
  S,
  H,
  L   : String;
  A,
  B,
  C   : Word;

Begin
  S:='{EMSI}{23:100/67}{}{8N1,PUA}{ZAP,ZMO,ARC,XMA}{15}{UnleadedMail}';
  S:=S + '{1.0}{Beta-1}{IDENT}{[Swanson''s BBS][your Mind!]';
  S:=S + '[Brian Swanson][1-901-373-3239][9600][XX,V32B,V42B]}';
  L:=HexW(Length(s));
  S:='EMSI_DAT    ' + S;
  S[9]:=L[1];
  S[10]:=L[2];
  S[11]:=L[3];
  S[12]:=L[4];
  H:=HexW(CRC16(S));
  Send(IDENT + S);
  SendLn(H);
End;

Function ReceiveEMSIDAT: Boolean;
Var
  S,
  L,
  InHex,
  CalcHex : String;
  X : Byte;

Begin
  For X:=1 To 10 Do
    S[X]:=ReceiveCharWithWait(Port);
  If S='**EMSI_DAT' Then
   Begin
     L:='';
     InKey:=ReceiveCharWithWait(Port);
     L:=L + InKey;
     InKey:=ReceiveCharWithWait(Port);
     L:=L + InKey;
     InKey:=ReceiveCharWithWait(Port);
     L:=L + InKey;
     InKey:=ReceiveCharWithWait(Port);
     L:=L + InKey;
     Tipe('Length Of Incoming EMSI_DAT is: '+L);
     S:='';
     InKey:=ReceiveCharWithWait(Port);
     While InKey<>#13 Do
      Begin
        S:=S + InKey;
        InKey:=ReceiveCharWithWait(Port);
      End;
     Tipe('Received:'+S);
     InHex:=Copy(S,Length(s)-4,4);
     S:='EMSI_DAT' + L + S;
     CalcHex:=HexW(CRC16(S));
     If InHex=CalcHex Then ReceiveEMSIDAT:=True
      Else ReceiveEMSIDAT:=False;
   End
  Else
   ReceiveEMSIDAT:=False;

End;

Function EMSICheck:Boolean;
Begin
  InKey:=ReceiveCharWithWait(Port);
  If InKey='*' Then
   Begin
    InKey:=ReceiveCharWithWait(Port);
    InKey:=Upcase(InKey);
    If InKey='E' Then
     Begin
      InKey:=ReceiveCharWithWait(Port);
      InKey:=UpCase(InKey);
      If InKey='M' Then
       Begin
         InKey:=ReceiveCharWithWait(Port);
         InKey:=Upcase(InKey);
         If InKey='S' Then
          Begin
           InKey:=ReceiveCharWithWait(Port);
           InKey:=Upcase(InKey);
           If InKey='I' Then
            Begin
              EMSICheck:=True;
            End
           Else
            Begin
             EMSICheck:=False;
             WriteChar(Inkey);
           End;
          End
         Else
           WriteChar(Inkey);
       End
      Else
        WriteChar(Inkey);
     End
    Else
     WriteChar(InKey);
   End;
End;

Function ReceiveEMSI(Var EMSI: String): Boolean;
Var
  S : String;
  InHex,
  CalcHex : String;
  CRC : Word;
Begin
  If EMSICheck Then
   Begin
     S:='EMSI';
     InHex:='';
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     S:=S + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     S:=S + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     S:=S + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     S:=S + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     InHex:=InHex + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     InHex:=InHex + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     InHex:=InHex + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     InKey:=Upcase(InKey);
     InHex:=InHex + Inkey;
     InKey:=ReceiveCharWithWait(Port);
     CalcHex:=HexW(CRC16(S));
     If CalcHex<>InHex Then
      Begin
        ReceiveEMSI:=False;
        EMSI:='';
      End
     Else
      Begin
        ReceiveEMSI:=True;
        EMSI:=Copy(S,6,3);
      End;
   End
  Else
   ReceiveEMSI:=False;
End;

Procedure StartEMSI;
Var
  Tries : Byte;
  S : String;
  Receive,
  Sent : Boolean;
Begin
  Sent:=False;
  SendEMSI('INQ');
  SendEMSI('INQ');
  SendLn('');
  PurgeInput(Port);
  Repeat
    SendHandshake;
    InKey:=ReceiveCharWithWait(Port);
    If (InKey='*') Then
     If ReceiveEMSI(S) Then
      Begin
        If S='ACK' Then
         Begin
           InKey:=ReceiveCharWithWait(Port);
           If (InKey='*') Then
            If ReceiveEMSI(S) Then
             If S='ACK' Then
              Begin
                Sent:=True;
                Tries:=0;
                Repeat
                  If (Not Receive) And (Tries>0) Then
                   Begin
                     SendEMSI('NAK');
                     If ReceiveEMSIDAT Then Receive:=True
                      Else Tries:=Tries + 1;
                   End;
                  If (Not Receive) And (Tries<1) Then
                   If ReceiveEMSIDAT Then Receive:=True
                    Else Tries:=Tries + 1;
                Until (Receive) Or (Tries>6);
                If Tries>6 Then
                 Begin
                  Tipe('EMSI_DAT Receive Failed...Aborting');
                  SetDTR(Port,FALSE);
                  Halt(0);
                 End;
                If Receive Then
                 Begin
                  SendEMSI('ACK');
                  SendEMSI('ACK');
                 End;
              End
         End;
      End;
  Until (Sent) And (Receive);

End;

Begin
   If OpenFossil(Port) Then
     Tipe('FOSSIL INITIALIZED');
   SetBaudRate(Port,BaudRate);
   Write('Phone Number:');
   ReadLn(S);
   SendLn('ATDT'+S);
   Repeat
    SendLn('');
   Until CharsInBuf(Port);
   OutKey:=#0;
   While OutKey<>#27 Do
    Begin
      If Not KeyPressed And CharsInBuf(Port) Then
       Begin
         InKey:=ReceiveChar(Port);
         WriteChar(InKey);
         If (InKey='*') Then
          If ReceiveEMSI(S) Then
           Begin
             If S='REQ' Then StartEMSI;
           End;
       End;
     If Keypressed Then
       OutKey:=ReadKey;
    End;
End.


---- Cut Here ----

This program goes as far as setting up the EMSI session, it does not however
parse the received EMSI info from the remote system.....If you look at the
function ReceiveEMSIDAT, at the point that it displays the contents of String
S.  The remote systems EMSI_DAT is stored in string S, so all you have to do is
parse it out to get the info.....If you need any other help concerning EMSI let
me know....