(* Note from Steve Wierenga: Part of these messages were cut off somewhere.
This should give you the basic structures, though. *)

{ Fido Pascal Conference  PASCAL 
Msg  : 293 of 317
From : MIKE COPELAND                       1:114/151.0          15 Jul 93  21:17
To   : STEVEN SHEELEY
Subj : ARCHIVE TPU 1/2

 SS> Does anyone have a TPU or know where I can get one that will
 SS> handle the viewing and unarchiving of the popular archivers?
 SS> (IE, ARJ, ZIP, LHA, PAK, Etc).

   This and the next message should help you...}
Uses Dos;
const
      BSize    = 4096;                                      { I/O Buffer Size }
      HMax     = 512;                                   { Header Maximum Size }
var
      I,J,K        : integer;
      CT,RC,TC     : integer;
      RES          : Word;                                   { Buffer Residue }
      N,P,Q        : Longint;
      C            : LongInt;                                 { Buffer Offset }
      FSize        : LongInt;                                     { File Size }
      DEVICE       : char;                                      { Disk Device }
      F            : File;
      SNAME        : String;
      DATE         : string[8];                  { formatted date as YY/MM/DD }
      TIME         : string[5];                  {     "     time as HH:MM    }
      DirInfo      : SearchRec;                       { File name search type }
      SR           : SearchRec;                       { File name search type }
      DT           : DateTime;
      PATH         : PathStr;
      DIR          : DirStr;
      FNAME        : NameStr;
      EXT          : ExtStr;
      Regs         : Registers;
      BUFF         : array[1..BSize] of Byte;

procedure FDT (LI : LongInt);                       { Format Date/Time fields }
begin
  UnPackTime (LI,DT);
  DATE := FSI(DT.Month,2)+'/'+FSI(DT.Day,2)+'/'+Copy(FSI(DT.Year,4),3,2);
  if DATE[4] = ' ' then DATE[4] := '0';
  if DATE[7] = ' ' then DATE[7] := '0';
  TIME := FSI(DT.Hour,2)+':'+FSI(DT.Min,2);
  if TIME[4] = ' ' then TIME[4] := '0';
end;  { FDT }

procedure  MY_FFF;
Var I,J,K : LongInt;

(**************************** ARJ Files Processing ***************************)
Type ARJHead = record
                 FHeadSize : Byte;
                 ArcVer1,
                 ArcVer2   : Byte;
                 HostOS,
                 ARJFlags,
                 Method    : Byte;   { MethodType = (Stored, LZMost, LZFast); }
                 R1,R2     : Byte;
                 DOS_DT    : LongInt;
                 CompSize,
                 UCompSize,
                 CRC       : LongInt;
                 ENP, FM,
                 HostData  : Word;
               end;
Var ARJ1     : ARJHead;
    ARJId    : Word;                                     { 60000, if ARJ file }
    HSize    : Word;                                            { Header Size }
procedure GET_ARJ_ENTRY;
begin
  FillChar(ARJ1,SizeOf(ARJHead),#0); FillChar(BUFF,BSize,#0);
  Seek (F,C-1); BlockRead(F,BUFF,BSIZE,RES);        { read header into buffer }
  Move (BUFF[1],ARJId,2);  Move (BUFF[3],HSize,2);
  if HSize > 0 then
    with ARJ1 do
      begin
        Move (BUFF[5],ARJ1,SizeOf(ARJHead));
        I := FHeadSize+5; SNAME := B40;
        while BUFF[I] > 0 do Inc (I);
        I := I-FHeadSize-5;
        Move (BUFF[FHeadSize+5],SNAME[1],I); SNAME[0] := Chr(I);
        FSize := CompSize; Inc (C,HSIZE);
      end;
end;  { GET_ARJ_ENTRY }

procedure DO_ARJ (FN : string);
begin
  Assign (F,FN); Reset (F,1); C := 1;
  GET_ARJ_ENTRY;                                            { Process file
Header }
  repeat
    Inc(C,FSize+10);
    GET_ARJ_ENTRY;
    if HSize > 0 then
      begin
        Inc (WPX); New(SW[WPX]);       { store filename info in dynamic array }
        with SW[WPX]^ do
          begin
            FSplit (SNAME,DIR,FNAME,EXT); F := FNAME; E := Copy(EXT+'    ',1,4)
            SIZE := ARJ1.UCompSize;
            RTYPE := 4; D_T := ARJ1.DOS_DT; ANUM := ADX; VNUM := VDX;
            ADD_CNAME;
          end;
        Inc (CCT); SSL; Inc (ARCS[ADX]^.COUNT)
      end;
  until HSize <= 0;
  Close (F);
end;  { DO_ARJ }

(**************************** ZIP Files Processing ***************************)
Type ZIPHead = record
                 ExtVer : Word;
                 Flags  : Word;
                 Method : Word;
                 Fill1  : Word;
                 DOS_DT        : LongInt;
                 CRC32         : LongInt;
                 CompSize      : LongInt;
                 UCompSize     : LongInt;
                 FileNameLen   : Word;
                 ExtraFieldLen : Word;
               end;
Var ZIPCSize : LongInt;
    ZIPId    : Word;
    ZIP1     : ZIPHead;
procedure GET_ZIP_ENTRY;
begin
  FillChar(ZIP1,SizeOf(ZIPHead),#0); Move (BUFF[C+1],ZIPId,2);
  if ZIPId > 0 then
    begin
      Move (BUFF[C+1],ZIP1,SizeOf(ZIPHead));
      Inc (C,43); SNAME := '';
      with ZIP1 do
        begin
          Move (BUFF[C],SNAME[1],FileNameLen); SNAME[0] := Chr(FileNameLen);
          FSize := CompSize;
        end;
    end;
end;  { GET_ZIP_ENTRY }

procedure DO_ZIP (FN : string);
const CFHS : string[4] = 'PK'#01#02;          { CENTRAL_FILE_HEADER_SIGNATURE }
      ECDS : string[4] = 'PK'#05#06;        { END_CENTRAL_DIRECTORY_SIGNATURE }
var S4     : string[4];
    FOUND  : boolean;
    QUIT   : boolean;                            { "end" sentinel encountered }
begin
  Assign (F,FN); Reset (F,1); C := 1; HSize := 0;
  FSize := FileSize(F);
  I := FSize-BSize;        { compute point to start read of central directory }
  Seek (F,I); BlockRead (F,BUFF,BSize,RES);      { read ZIP central directory
}
  S4[0] := #4; C := 2;
  repeat
    FOUND := false; QUIT := false; { search for CENTRAL_FILE_HEADER_SIGNATURE }
    while (not QUIT) and (not FOUND) do                 { modified B-M search }
      begin

(**************************** ARC Files Processing ***************************)
Type ARCHead = record
                 ARCMark   : char;
                 ARCVer    : Byte;
                 FN        : array[1..13] of char;
                 CompSize  : LongInt;
                 DOS_DT    : LongInt;
                 CRC       : Word;
                 UCompSize : LongInt;
               end;
const ARCFlag : char = #26;                                        { ARC mark }
Var WLV   : LongInt;                               { Working LongInt Variable }
    ARC1  : ARCHead;
    QUIT  : boolean;                             { "end" sentinel encountered }

procedure GET_ARC_ENTRY;
begin
  FillChar(ARC1,SizeOf(ARCHead),#0); L := SizeOf(ARCHead);
  Seek (F,C); BlockRead (F,BUFF,L,RES);
  Move (BUFF[1],ARC1,L);
  with ARC1 do
    if (ARCMark = ARCFlag) and (ARCVer > 0) then
      begin
        SNAME := ''; I := 1;
        while FN[I] <> #0 do
          begin
            SNAME := SNAME+FN[I]; Inc(I)
          end;
        WLV := (DOS_DT Shr 16)+(DOS_DT Shl 16);              { flip Date/Time }
        FSize := CompSize;
      end;
    QUIT := ARC1.ARCVer <= 0;
end;  { GET_ARC_ENTRY }

procedure DO_ARC (FN : string);
begin
  Assign (F,FN); Reset (F,1); C := 0;
  repeat
    GET_ARC_ENTRY;
    if not QUIT then
      begin
        Inc (WPX); New(SW[WPX]);       { store filename info in dynamic array }
        with SW[WPX]^ do
          begin
            FSplit (SNAME,DIR,FNAME,EXT); F := FNAME; E := Copy(EXT+'    ',1,4)
            SIZE := ARC1.UCompSize; RTYPE := 4;                   { comp file }
            D_T := WLV; ANUM := ADX; VNUM := VDX;
            ADD_CNAME;
          end;
        Inc (CCT); SSL; Inc (ARCS[ADX]^.COUNT)
      end;
    Inc (C,FSize+SizeOf(ARCHead))
  until QUIT;
  Close (F);
end;  { DO_ARC }

(************************* LZH Files Processing ******************************)
Type LZHHead = record
                 HSize       : Byte;
                 Fill1       : Byte;
                 Method      : array[1..5] of char;
                 CompSize    : LongInt;
                 UCompSize   : LongInt;
                 DOS_DT      : LongInt;
                 Fill2       : Word;
                 FileNameLen : Byte;
                 FileName    : array[1..12] of char;
               end;

Var LZH1     : LZHHead;

procedure GET_LZH_ENTRY;
begin
  FillChar(LZH1,SizeOf(LZHHead),#0); FillChar (DT,SizeOf(DT),#0);
  L := SizeOf(LZHHead);
  Seek (F,C); BlockRead (F,BUFF,L,RES);
  Move (BUFF[1],LZH1,L);
  with LZH1 do
    if HSize > 0 then
      begin
        Move (FileNameLen,SNAME,FileNameLen+1);
        UnPackTime (DOS_DT,DT);
        FSize := CompSize;
      end
    else QUIT := true
end;  { GET_LZH_ENTRY }

procedure DO_LZH (FN : string);
begin
  Assign (F,FN); Reset (F,1);
  FSize := FileSize(F); C := 0; QUIT := false;
  repeat
    GET_LZH_ENTRY;
    if not QUIT then
      begin
        Inc (WPX); New(SW[WPX]);       { store filename info in dynamic array }
        with SW[WPX]^ do
          begin
            FSplit (SNAME,DIR,FNAME,EXT); F := FNAME; E := Copy(EXT+'    ',1,4)
            SIZE := LZH1.UCompSize;
            RTYPE := 4; ANUM := ADX; VNUM := VDX; D_T := LZH1.DOS_DT;
            ADD_CNAME;
          end;
        Inc (CCT); SSL; Inc (ARCS[ADX]^.COUNT)
      end;
    Inc (C,FSize+LZH1.HSize+2)
  until QUIT;
  Close (F);
end;  { DO_LZH }

(************************* ZOO Files Processing ******************************)

Type ZOOHead = record
                 ZOOMark  : array[1..4] of char;
                 ZOOType  : char;
                 ZOOPack  : char;
                 ZOONext  : LongInt;
                 ZOOOff   : LongInt;
                 DOS_DT   : LongInt;
                 ZOOCRC   : Word;
                 UCSize   : LongInt;
                 CompSize : LongInt;
                 Fill     : array[1..10] of char;
                 ZOOName  : array[1..13] of char;
               end;
Type ZOOHT   = record
                 Fill1    : array[1..20] of char;
                 ZOOMark  : array[1..4] of char;
                 ZOOStart : LongInt;
                 ZOOChk   : LongInt;
                 Fill2    : Word;
               end;

Var ZOO1     : ZOOHead;
    ZOOX     : ZOOHT;

procedure GET_ZOO_ENTRY;
begin
  FillChar(ZOO1,SizeOf(ZOOHead),#0); FillChar (DT,SizeOf(DT),#0);
  L := SizeOf(ZOOHead); Seek (F,C); BlockRead (F,BUFF,L,RES);
  Move (BUFF[1],ZOO1,L);
  with ZOO1 do
    if ZOONext > 0 then
      begin
        Move (ZOOName,SNAME[1],13); SNAME[0] := #0; I := 1;
        while SNAME[I] > #0 do
          begin
            Inc(I); Inc (SNAME[0]);
