{ Fido Pascal Conference  PASCAL 
Msg  : 343 of 375
From : David Drzyzga                       1:3612/220.0         30 May 93  06:10
To   : All
Subj : A File

The other day I saw a message with some code in it that made a .ARC file from
an array, so I decided to write someething that would do that. How about an
example:

DUMPFILE TEST.ZIP  Will create a file called MAKEFILE.PAS

If you compile and run MAKEFILE, it will re-create the file TEST.ZIP

Well, that wasn't as hard as I thought it was going to be <grin>. Here's
DUMPFILE.PAS:}

program dumpfile;
{-Dumps any file (32k or less) into source code that will rebuild it}

var
  InFile  : File;
  OutFile : Text;
  InByte  : Byte;
  FilSiz,
  OutStr  : String[5];
  Counter : Integer;
  InBuff  : array[1..31744] of byte;
  OutBuff : array[1..31744] of char;
  RecordsRead  : integer;

Procedure Header;
Begin
  WriteLn(OutFile, 'Program MakeFile;');
  WriteLn(OutFile, '');
  WriteLn(OutFile, 'Var');
  WriteLn(OutFile, '  F : File;');
  WriteLn(OutFile, '');
  WriteLn(OutFile, 'Const');
  WriteLn(OutFile, '  ByteArray : Array[1..' + FilSiz + '] Of Byte = (');
End;

Procedure Footer;
Begin
  WriteLn(OutFile, '');
  WriteLn(OutFile, 'Begin');
  WriteLn(OutFile, '  Assign(F,''' + ParamStr(1) + ''');');
  WriteLn(OutFile, '  ReWrite(F,' + FilSiz + ');');
  WriteLn(OutFile, '  BlockWrite(F,ByteArray,1);');
  WriteLn(OutFile, '  Close(F);');
  WriteLn(OutFile, 'End.');
End;

Begin
  Assign(InFile, Paramstr(1));
  Assign(OutFile, 'MAKEFILE.PAS');
  SetTextBuf(OutFile, OutBuff);
  Reset(InFile,1);
  If FileSize(InFile) > 32769 Then Halt; {file was too big}
  ReWrite(OutFile);
  Str(FileSize(InFile), FilSiz);
  Header;
  Repeat
    BlockRead(InFile,InBuff,SizeOf(InBuff),RecordsRead);
    Write(OutFile, '    ');
    For Counter := 1 To RecordsRead Do Begin
      Str(InBuff[Counter], OutStr);
      If (Counter = RecordsRead) And EOF(InFile) Then
        WriteLn(OutFile, OutStr + ');')
      Else
        Write(OutFile, OutStr + ',');
      If (Counter MOD 19 = 0) or 
         (Counter = RecordsRead) And
         Not EOF(InFile) Then Begin
        WriteLn(OutFile, '');
        Write(OutFile, '    ');
      End;
    End;
  Until RecordsRead = 0;
  Footer;
  Close(InFile);
  Close(OutFile);
End.

This will only work with files 32k or less.. don't know who would want to dump 
a larger file into an array anyways.  I hacked this together in a few minutes
but it works on *any* valid DOS file.