{ Fido Pascal Conference  PASCAL 
Msg  : 224 of 465
From : Lou Duchez                          1:157/200.0          17 Jun 93  07:52
To   : Robert Cadena
Subj : WINDOW TRICKS

RC> When I open the window, I want to give it a shadow, in C what you
RC>would do is switch the 2nd bit of each character.

Shadowing here.  You'll need "Crt" for this to work:
-------------------------------------------------------------------------------
-}

procedure atshadow(x1, y1, x2, y2: byte);

{ Makes a "shadow" to the right of and below a screen region, by setting the
  foreground there to low intensity and the background to black. }

type  videolocation = record
        videodata: char;
        videoattribute: byte;
        end;

var xbegin, xend, ybegin, yend, xcnt, ycnt: byte;
    videosegment: word;
    monosystem: boolean;
    vidptr: ^videolocation;

begin

{ Determine location of video memory. }

  monosystem := (lastmode in [0,2,7]);
  if monosystem then videosegment := $b000 else videosegment := $b800;

{ Determine the x coordinates where the shadowing begins and ends on the lower
  edge.  (Basically two spaces to the right of the box.) }

  xbegin := x1 + 2; xend := x2 + 2;

{ Determine the y coordinates where the shadowing begins and ends on the
  right.  (Basically one row below the box.) }

  ybegin := y1 + 1; yend := y2 + 1;
  ycnt := ybegin;
  while (ycnt <= yend) and (ycnt <= 25) do begin

{ This loop goes through each row, putting in the shadows on the right and
  bottom.  First thing to check on each pass: if we're not below the region
  to shadow, shade only to the right.  Otherwise, start at the left. }

    if ycnt > y2 then xcnt := xbegin else xcnt := x2 + 1;
    vidptr := ptr(videosegment, 2*(80*(ycnt - 1) + (xcnt - 1)));
    while (xcnt <= xend) and (xcnt <= 80) do begin

{ This loop does the appropriate shadowing for this row. }

      vidptr^.videoattribute := vidptr^.videoattribute and $07; { SHADOW! }
      xcnt := xcnt + 1;
      inc(vidptr);
      end;
    ycnt := ycnt + 1;
    end;
  end;

-------------------------------------------------------------------------------
-
RC> In C there is a function that gets a portion of the screen, saves it in 
RC>a buffer and the another funtion that puts that buffer on the screen.  Could
RC>someone make these funtions in PASCAL please.

I find it faster to save entire screens.  To save an entire screen:

1) make a pointer variable
2) allocate 4000 bytes to it via "GetMem"
3) use the "Move" procedure to copy video memory to/from the buffer

Example:
-------------------------------------------------------------------------------
-

var buffy, videoimage: pointer;
    monosystem: boolean;
    videosegment: word;

{ Figure out where video memory is }

monosystem := (lastmode in [0,2,7]);
if monosystem then videosegment := $b000 else videosegment := $b800;
videoimage := ptr(videosegment, $0000);

getmem(buffy, 4000);
move(videoimage^, buffy^, 4000); { saves screen }
move(buffy^, videoimage^, 4000); { restores screen }