{ Fido Pascal Conference  PASCAL 
Msg  : 250 of 362
From : Wilbert van Leijen                  2:281/256.14         28 May 93  20:01
To   : John Pittman                        1:100/602.2
Subj : Pause Key

19 May 93, John Pittman writes to All:

 JP>         Does anyone know how to disable the pause key? We have a TVision
 JP> (TP6) application that the users sometimes hit the pause and leave the
 JP> room. This would be OK, but the application normally is pulling
 JP> information from the com port durring idle. Pause kills this. Any
 JP> suggestions?

Hook onto the keyboard interrupt and swallow each keypress of Pause.}

uses Dos;

{$R-,S- }

{.$DEFINE DEBUG }

Var
  SavedInt9 : Pointer;

Procedure EatPauseKey; Interrupt; Assembler;

Const
  pause        = $61;                  { Pause make code }
  KbdPort      = $60;                  { Keyboard port }
  KbdCtrlPort  = $61;                  { Keyboard control port }
  PIC          = $20;                  { 8259 Interrupt controller }
  EOI          = $20;                  { End-of-interrupt }

ASM
        STI
        IN     AL, KbdPort
        AND    AL, 01111111b
        CMP    AL, pause
        JNE    @1

{$IFDEF DEBUG }
        MOV    AL, 7
        INT    29h
{$ENDIF }
        IN     AL, KbdCtrlPort
        MOV    AH, AL
        OR     AL, 10000000b
        OUT    KbdCtrlPort, AL
        XCHG   AH, AL
        OUT    KbdCtrlPort, AL
        CLI
        MOV    AL, EOI
        OUT    PIC, AL
        JMP    @2

@1:     PUSHF
        CALL   DWord Ptr [SavedInt9]
@2:
end;  { EatPauseKey }

Procedure TrashTest;

Var
  s            : String;

Begin
  WriteLn('Enter some characters.  Pause key is disabled!');
{$IFDEF DEBUG }
  WriteLn('You''ll hear a beep to confirm pressing the <Pause> key.');
{$ENDIF }
  WriteLn('Empty line quits.');
  Repeat
    ReadLn(s);
    WriteLn(s);
  Until s = '';
end;  { Loop }

Begin
  GetIntVec(9, SavedInt9);
  SetIntVec(9, @EatPauseKey);
  TrashTest;
  SetIntVec(9, SavedInt9);
end.