{ Fido Pascal Conference  PASCAL 
Msg  : 402 of 413
From : Todd Holmes                         1:152/5.0            25 Jun 93  10:23
To   : All
Subj : Unit Cstr: Nul term strings for streams
}
Unit Cstr;

{Unit CStr
 by Todd Holmes
 Created: 6/21/93
 Last Modified: Never

 Tested

 Cstr is a unit to suppliment the writing and reading of Nul terminating
 strings to and from Streams. Cstr also offers conversion from Pascal strings
 to Nul term Strings.

 Future Improvements: Error checking needs to be expanded
                      Turn it into an Object}

{$O+,X+,F+}         {Allow unit to be overlaid, extented syntax (required for
                    using the Strings Unit, Force Far calls}
Interface

Uses Strings, Objects;

Const

  MaxCstrLen = 65528; {max amount in bytes that can be allocated on the heap}
  MaxPstrLen = 256;   {Max length of a pascal style string}

Var

   MaxLen: Word; {Defines the maximum size of a nul string that can
                    be read from a stream. The unit sets this to MaxPStrLen
                    by default, but if you want to read in longer strings from
                    a stream, this value may not be larger the MaxCstrLen}

Procedure StoreCstr( Var S:TStream; Cstr: PChar);
{Writes Nul terminating String to a stream}

Procedure StorePstr(VAr S:TStream; PStr: STring);
{Converts a Pas string to a nul term str and writes to a stream}


Function LoadCStr(Var S:TStream): PChar;
{Loads a Nul term String from a stream, assumes the stream is positioned
 at the start of the string to be read in}

Function LoadPStr(Var S: TStream):String;
{Loads a Nul term string and converts it to a Pascal string}



Implementation
Procedure StoreCstr( Var S:TStream; Cstr: PChar);
{Writes Nul terminating String to a stream}
 begin
   S.Write(Cstr^,Strlen(Cstr)+1);
 end;

Procedure StorePstr(VAr S:TStream; PStr: STring);
var
 Cstr: PChar;
 begin
   Getmem(Cstr,Length(Pstr)+1);   {Allocate memory on the heap}
   StrPCopy(CStr,Pstr);           {Strings Unit: Converts Pstr to CStr}
   StoreCstr(S,Cstr);             {Stores the CStr}
   FreeMem(Cstr,Length(Pstr)+1);  {Frees up the Allocated memory}
 end;

Function LoadCStr(Var S:TStream): PChar;
var
 Start,Stop: LongInt;
 L: Word;
 Buf: Char;
 CStr: PChar;
begin
  Start := S.GetPos;
  Repeat              {Scan for end of string, (nul term char: #0)}
    S.Read(Buf,1);    {no need for a larger buffer, since were using
                       TBufStream with a 1 k buffer}
  Until Buf = #0;
  Stop := S.GetPos;
  if (stop - Start) > MaxLen then LoadCStr := Nil {string is to big!}
                      {Needs additon error checking here}
  Else
    begin
     L := Stop - Start; {Get Length of string, include nul terminator}
     GetMem(CStr,L);    {Allocate memory}
     S.Seek(Start);     {repostion}
     S.Read(CStr^,L);   {Read the string}
     LoadCStr := CStr;
    end;
end; {LoadCstr}

Function LoadPStr(Var S: TStream):String;
{Loads a Nul term string and converts it to a Pascal string}
var
 PStr : String;
 CStr : PChar;
 begin
   CStr := LoadCStr(S);           {Loads a nul term string}
   If CStr  = nil then PStr := ''
   Else PStr := StrPas(CStr);     {Converts CStr to a Pascal String}
   LoadPStr := PStr;
 end;

begin
  MaxLen := MaxPStrLen; {Set default CStr Length, your program should set
                        this to any value less then MaxCStrLen}
end.