program TypeOfEquipMaintainance;

uses Crt, Dos;
type

   DateType = record
                Year:  string[2];
                Month: string[2];
                Day:   string[2];
          end;
   FileNameType = string[24];

   ModelNameType = string[12];
   SNType = record
                FirstWord: string[2];
                SNKey:     string[8];
                SNRest:    string[6]
            end;
   PlatenNoType     = string[8];
   CustomerCodeType = string[12];
   LocationType     = string[20];
   ContractorType   = string[20];
   SetUpDateType    = DateType;

   AEquipmentRecordType = record
                            ModelName:    ModelNameType;
                            SN:           SNType;
                            PlatenNo:     PlatenNoType;
                            CustomerCode: CustomerCodeType;
                            Location:     LocationType;
                            Contractor:   ContractorType;
                            SetUpDate:    SetUpDateType
                         end;

   EquipmentFileType = file of AEquipmentRecordType;

   EquipPtrType = ^EquipNode;
   EquipNode = record
                  AData: AEquipmentRecordType;
               end;
   EquipPtrArrayType = array[1..100] of EquipPtrType;

   {---------------------}

   String50 = string[50];
   String20 = string[20];

   AMaintenanceCardType = record
                             CardDate: DateType;
                             SNo:      SNType;
                             Symptoms: String50;
                             Process:  String50;
                             Remark:   String50
                          end;

   MaintenanceFileType = file of AMaintenanceCardType;


var

   EquipFileVar: EquipmentFileType;
   MaintFileVar: MaintenanceFileType;

   EquipFileName,
   MaintFileName: FileNameType;

   EquipPtrArray: EquipPtrArrayType;
   TotalEquipRecord: integer;


procedure AssignFiles( var EquipFileName, MaintFileName: FileNameType );
   const
      TestEquipFileName = 'a:Equip';
      TestMaintFileName = 'a:Maint';
   begin

      EquipFileName := TestEquipFileName;
      MaintFileName := TestMaintFileName;

      Assign( EquipFileVar, EquipFileName );
      Assign( MaintFileVar, MaintFileName );

   end; { of proc OpenFiles }

procedure ReadEquipmentFile( var EquipPtrArray: EquipPtrArrayType;
                             var TotalEquipRecord: integer );
   var
      Count: integer;
      AEquipData: AEquipmentRecordType;
   begin
      Reset( EquipFileVar );
      TotalEquipRecord :=  FileSize( EquipFileVar );
      for Count := 1 to TotalEquipRecord do begin
         Read( EquipFileVar, AEquipData );
         New( EquipPtrArray[Count] );
         EquipPtrArray[Count]^.AData := AEquipData;
      end;
      Close( EquipFileVar );
   end;


procedure DisplayTitle;
   begin
      writeln;
      HighVideo;
      writeln( ' NO MODEL    SERIAL NO       PLANTEN  CUSTOMER   LOCATION     CONTRACTOR DATE' );
      NormVideo;
   end; { of proc DisplayTitle }

{
0        1         2         3         4         5         6         7
1234567890123456789012345678901234567890123456789012345678901234567890123456789
 NO MODEL    SERIAL NO       PLANTEN  CUSTOMER   LOCATION     CONTRACTOR DATE
123 12345678 12345678-123456 12345678 1234567890 123456789012 1234567890 123456


0        1         2         3         4         5         6         7
1234567890123456789012345678901234567890123456789012345678901234567890123456789
==============================================================================
| RECORD NO  123            MODEL NO 12345678       SN     WP12345678-123456 |
| CUSTOMER   123456789012   LOCATION 123456789012   PLATEN 12345678          |
| CONTRACTOR 123456789012344567890              SETUP DATE XX/XX/XX          |
==============================================================================
}

procedure SetWindow( X1, Y1, X2, Y2: integer );
   const
      UpLeftCorner    = #201;
      HorzBar         = #205;
      UpRightCorner   = #187;
      VertBar         = #186;
      LowLeftCorner   = #200;
      LowRightCorner  = #188;
   var
      I: integer;
   begin
      HighVideo;
      Window( 1, 1, 80, 25 );
      GoToXY( X1-1, Y1-1 );
      write( UpLeftCorner );
      for I := X1 to X2 do
         write( HorzBar );
      write( UpRightCorner );
      for I := Y1 to Y2 do begin
         GoToXY( X1-1, I ); write( VertBar );
         GoToXY( X2+1, I ); write( VertBar )
      end;
      GoToXY( X1-1, Y2+1 );
      write( LowLeftCorner );
      for I := X1 to X2 do
         write( HorzBar );
      write( LowRightCorner );
      NormVideo;
      Window( X1, Y1, X2, Y2 )
   end; { of proc SetWindow }

procedure DisplayItemTitles;
   const
      X1 =  2;
      Y1 = 22;
      X2 = 78;
      Y2 = 24;
   begin
      SetWindow( X1, Y1, X2, Y2 );
      GotoXY( 1, 1 );
      TextAttr := White;
      LowVideo;
      writeln( ' RECORD NO                 MODEL NO                SN               -');
      writeln( ' CUSTOMER                  LOCATION                PLATEN' );
      write(   ' CONTRACTOR                                    SETUP DATE   /  /' );
      NormVideo;
      Window( 1, 3, 80, 20 );
   end;

procedure DisplayItemContents( RecordNo: integer; ARecord: AEquipmentRecordType );
   type ItemPos = array[0..11] of array[0..1] of Byte;
   const
      XYPos: ItemPos = ((1,13),(1,37),(1,59),(1,61),(1,70),
                        (2,13),(2,37),(2,59),
                        (3,13),       (3,59),(3,62),(3,65));
    begin
       Window( 2, 22, 78, 24 );
       HighVideo;
       GotoXY( XYPos[0,1], XYPos[0,0] ); write( RecordNo );
       with ARecord do begin
         GotoXY( XYPos[1,1], XYPos[1,0] ); write( ModelName );
         with SN do begin
            GotoXY( XYPos[2,1], XYPos[2,0] ); write( FirstWord );
            GotoXY( XYPos[3,1], XYPos[3,0] ); write( SNKey );
            GotoXY( XYPos[4,1], XYPos[4,0] ); write( SNRest );
         end;
         GotoXY( XYPos[5,1], XYPos[5,0] ); write( PlatenNo );
         GotoXY( XYPos[6,1], XYPos[6,0] ); write( CustomerCode );
         GotoXY( XYPos[7,1], XYPos[7,0] ); write( Location );
         GotoXY( XYPos[8,1], XYPos[8,0] ); write( Contractor );
         with SetUpDate do begin
            GotoXY( XYPos[ 9,1], XYPos[ 9,0] ); write( Year );
            GotoXY( XYPos[10,1], XYPos[10,0] ); write( Month );
            GotoXY( XYPos[11,1], XYPos[11,0] ); write( Day );
         end;
       end;
       NormVideo;
       Window( 1, 3, 80, 20 );
    end;

procedure DisplayItem( Item: String20; Cnt: integer );
   var Leng,
       X: integer;
   begin
      Leng := Length( Item );
      if Leng >= Cnt then begin
         for X := 1 to Cnt do
            write( Item[X] );
         write( ' ' );
      end else
         write( Item, ' ':(Cnt-Leng+1) );
   end; { of proc DisplayItem }

Procedure DisplayAEquip( NO: integer; AEquipRecord: AEquipmentRecordType );
   var Item: String20;
   begin
      with AEquipRecord do begin
         write( NO:3, ' ' );
         Item := ModelName;    DisplayItem( Item, 8 );
         write( SN.SNKey, '-', SN.SNRest, ' ' );
         write( PlatenNo, ' ' );
         Item := CustomerCode; DisplayItem( Item, 10 );
         Item := Location;     DisplayItem( Item, 12 );
         Item := Contractor;   DisplayItem( Item, 10 );
         Item := SetUpDate.Year + SetUpDate.Month + SetUpDate.Day;
                               DisplayItem( Item, 6 );
      end
   end;

procedure DisplayProcess( EquipPtrArray: EquipPtrArrayType;
                          TotalEquipRecord: integer );
   var AEquipRecord: AEquipmentRecordType;
       RecordNo : integer;
       OldPositionX,
       OldPositionY: byte;
       ch: char;
       Test: integer;
   begin
      ClrScr;
      DisplayTitle;
      DisplayItemTitles;
      GotoXY( 1,1 );
      ch := readKey;
   for Test := 1 to 10 do begin
      for RecordNo := 1 to TotalEquipRecord do begin
         DisplayAEquip( RecordNo, EquipPtrArray[RecordNo]^.AData );
         OldPositionX := WhereX; OldPositionY := WhereY;
         DisplayItemContents( RecordNo, EquipPtrArray[RecordNo]^.AData );
         GotoXY( OldPositionX, OldPositionY );
         ch := ReadKey;
      end;
   end;
      window( 1, 1, 80, 25 );
   end;

begin { of program }
   AssignFiles( EquipFileName, MaintFileName );
   ReadEquipmentFile( EquipPtrArray, TotalEquipRecord );
   DisplayProcess( EquipPtrArray, TotalEquipRecord );
end.
