{ copyright - october 1992 Fernando Padilla
 This is a phone company bill printing program....
  It calculates the gross, net, and taxed amounts and prints them out, if
  the data is valid---Page 93, problem #17}

program NTC;
uses
     crt;
const
     taxrate=0.04;
     rate=0.4;
type
     customer=record
          phonenumber:string[8];
          starttime:integer;
          length:integer;
          gross:real;
          net:real;
          tax:real;
     end;

procedure input(var inputfile:text; var whiner:customer);
begin
     with whiner do
     begin
          readln(inputfile,phonenumber);
          readln(inputfile,starttime);
          readln(inputfile,length);
     end;
end;

function testdata(whiner:customer):boolean;
var
     arm,len:boolean;
begin
     testdata:=true;
     with whiner do
     begin
          if (length<=1440) and (length>=1) then len:=true
          else len:=false;
          if (starttime<=2400) and (length>=1) then arm:=true
          else arm:=false;
          if not arm or not len then testdata:=false;
     end;
end;

function gross(length:integer):real;
begin
     gross:=length*rate;
end;

function net(whiner:customer):real;
begin
     case (whiner.starttime) of
          0800..1799: net:=(whiner.gross);
     else net:=(whiner.gross)*0.5;
     end;
     if (whiner.length)>=60 then net:=(whiner.gross)*0.85;
end;

function returnaftertax(whiner:customer):real;
begin
     returnaftertax:=(whiner.net)*(1+taxrate);
end;

procedure processing(var whiner:customer);
begin
     whiner.gross:=gross(whiner.length);
     whiner.net:=net(whiner);
     whiner.tax:=returnaftertax(whiner);
end;

procedure output(whiner:customer);
var
     i:integer;
begin
     clrscr;
     with whiner do
     begin
          gotoxy(25,1);
               write('Customer phonenumber: ',phonenumber);
          gotoxy(27,2);
               write('The following call bill:');
          gotoxy(1,4);
               write('Starting Time: ',starttime);
          gotoxy(40,4);
               write('Length of call: ',length);
          gotoxy(1,6);
               write('Raw');
          gotoxy(20,6);
               write('Discounted');
          gotoxy(40,6);
               write('Tax included');
          for i:=1 to 18 do
          begin
               gotoxy(i,7);
                    write('-');
               gotoxy(i+20,7);
                    write('-');
               gotoxy(i+40,7);
                    write('-');
          end;
          gotoxy(1,8);
               write('$',gross:17:2);
          gotoxy(20,8);
               write('$',net:17:2);
          gotoxy(40,8);
               write('$',tax:17:2);
          readln;
     end;
end;

procedure errorfound(whiner:customer);
begin
     clrscr;
     with whiner do
     begin
          gotoxy(25,1);
               write('Customer phonenumber: ',phonenumber);
     end;
     textattr:=textattr+blink;
     gotoxy(1,4);
          write('THIS Customer PHONE CALL record is invalid');
     gotoxy(1,5);
          write('     PLEASE do something do something about it!');
     textattr:=textattr-blink;
     readln;
end;

procedure runcustomer;
var
     user:customer;
     inputfile:text;
begin
     assign(inputfile,'a:\ntc.dat');
     reset(inputfile);
     while not eof(inputfile) do
     begin
          input(inputfile,user);
          if testdata(user) then begin
               processing(user);
               output(user);
          end
          else begin
               errorfound(user);
          end;
     end;
     close(inputfile);
end;

begin {NTC}
     runcustomer;
end.