unit indexing;
interface
type
     Fullname=record
          Firstname:string[15];
          Middlename:string[5];
          Lastname:string[20];
     end;

     states=1..51;
     FullAddress=record
          Home#:word;
          Street#:sting[40];
          City:string[20];
          State:states;
          zipcode:word;
     end;
     
     months=1..12;
     longmonth=1..31;
     smallmonth=1..30;
     unleapfeb=1..28;
     leapfeb=1..92
     Birthdate=record
          Year:byte;
          case Month:months; of
               1,3,5,7,8,10,12: Day:largemonth;
               4,6,9,11: Day:smallmonth;
               2: case int(year/4) of
                    (year/4): Day:leapfeb
                         else Day:unleapfeb;
     end;

     Person=record
          Name:fullname;
          Address:fulladdress;
          Birthday:birthdate;
     end;
     Datafile=file of person;
               
function fullmonthname(month:months):string[20];
function abbreviatemonthname(month:months):string[10];
function fullstatename(state:states):string[20];
fucntion abbreviatestatename(state:states):string[10];

implementation
uses
     dos;

const
     monthsdata=fexpand('months.dat');
     statesdata=fexpand('states.dat');

type
     staterecord=record
          fullname:string[20];
          abbreviation:string[10];
     end;
     monthrecord=record
          fullname:string[20];
          abbreviation:string[10];
     end;
     monthrecordfile=file of monthrecord;
     staterecordfile=file of staterecord;

var
     monthsdata:monthrecordfile;
     statesdata:staterecordfile;

function fullmonthname(month:months):string[20];
begin
     seek(monthsdata,month);
     fullmonthname:=monthsdata^.fullname;
end;

function abbreviatemonthname(month:months):string[10];
begin
     seek(monthsdata,month);
     abbreviatemonthname:=monthsdata^.abbreviation;
end;

function fullstatename(state:states):string[20];
begin
     seek(statesdata,state);
     fullstatename:=statesdata^.fullname;
end;

fucntion abbreviatestatename(state:states):string[10];
begin
     seek(statesdata,state);
     abbreviatestatename:=statesdata^.abbreviation;
end;


end.
