program problem5at1992;
{$R-}
type
   timetype=record
      original:string;
      weight:longint;
      hh:byte;
      mm:byte;
      ss:byte;
   end;
   datetype=record
      original:string;
      year:word;
      years:string[5];
      month:byte;
      day:byte;
   end;
   appointmenttype=record
      time:timetype;
      date:datetype;
      original:string[100];
   end;
procedure capitalize(var streng:string);
var
   a:integer;
begin
   for a:=1 to length(streng) do
      streng[a]:=upcase(streng[a]);
end;

procedure increte(var streng:string);
const
   needed=['P','M','N','A','0'..'9','/',':',' '];
var
   a:integer;
begin
   a:=0;
   repeat
      inc(a);
      if not(streng[a] in needed) then
      begin
         delete(streng,a,1);
         dec(a);
      end;
   until a=length(streng);
end;

procedure sink(var streng:string;  position:integer);
const
   sinkable=['A'..'Z',' '];
var
   a:integer;
begin
   if position>0 then
      for a:=position+1 downto position-1 do
         if streng[a] in sinkable then delete(streng,a,1);
end;

procedure move(var streng1,streng2:string; start,finish:integer);
var
   a:integer;
begin
   for a:=start to finish do
      streng2:=concat(streng2,streng1[a]);
   delete(streng1,start,finish-start+1);
end;

procedure center(var streng:string);
const
   number=['0'..'9'];
var
   temps:string;
   a:integer;
begin
   temps:='';
   sink(streng,pos('A',streng)-2);
   sink(streng,pos('P',streng)-2);
   sink(streng,pos(':',streng));
   move(streng,temps,1,pos(':',streng)+1);
   sink(streng,pos(':',streng));
   move(streng,temps,1,pos(':',streng)+1);
   sink(streng,pos('/',streng));
   move(streng,temps,1,pos('/',streng)+1);
   sink(streng,pos('/',streng));
   move(streng,temps,1,pos('/',streng)+1);
   repeat
      a:=length(streng);
      sink(streng,a);
   until streng[a] in number;
   streng:=concat(temps,streng);
end;

procedure devide(temps:string;  var streng1,streng2:string);
begin
   move(temps,streng1,1,pos(' ',temps)-1);
   sink(temps,1);
   streng2:=temps;
end;

procedure clear(var appointment:appointmenttype);
begin
   with appointment do
   begin
      original:='';
      with time do
      begin
         original:='';
         weight:=0;
         hh:=0;
         mm:=0;
         ss:=0;
      end;
      with date do
      begin
         original:='';
         year:=0;
         years:='';
         month:=0;
         day:=0;
      end;
   end;
end;

procedure desifertime12(var time:timetype);
var
   temps,temphh,tempmm,tempss:string;
begin
   temps:=time.original;
   move(temps,temphh,1,pos(':',temps)-1);
   del(temps,pos(':',temps),1);
   if pos(':',temps)=0 then tempmm:=temps
   else begin
      move(temps,tempmm,1,pos(':',temps)-1);
      del(temps,pos(':',temps),1);
      if length(temps)>0 then tempss:=temps;
   end;
   temphh:=value(temphh);
   tempmm:=value(tempmm);
   tempss:=value(tempss);
end;

procedure desifertime(var time:timetype);
var
   temps,temphh,tempmm,tempss:string;
begin
   temps:=time.original;
   if pos('M',temps)+pos('N',temps)=0 then
   begin
      move(temps,temphh,1,pos(':',temps)-1);
      del(temps,pos(':',temps),1);
      if pos(':',temps)=0 then tempmm:=temps
      else begin
         move(temps,tempmm,1,pos(':',temps)-1);
         del(temps,pos(':',temps),1);
         if length(temps)>0 then tempss:=temps;
      end;
      time.hh:=value(temphh);
      time.mm:=value(tempmm);
      time.ss:=value(tempss);
   end
   else desifertime12(time);
end;






















procedure splice(var appointment:appointmenttype);
var
   temps:string;
begin
   temps:=appointment.original;
   capitalize(temps);
   increte(temps);
   center(temps);
   devide(temps,appointment.time.original,appointment.date.original);
end;

procedure control;
var
   batchfile:text;
   tempr:appointmenttype;
begin
   assign(batchfile,'a:p5-data.dat');
   reset(batchfile);
   writeln;
   writeln;
 repeat
   clear(tempr);
   readln(batchfile,tempr.original);
   splice(tempr);
   write(tempr.time.original,' ',tempr.date.original);
   readln;
 until eof(batchfile);
end;

begin
   control;
end.