UNIT TVPARSER;

{ A Dialog to input Data for the PVarParser defined in Unit Parser

   (C) M.Fiel 1993 Vienna - Austria
   CompuServe ID : 100041,2007

   Use freely if you find it useful.

}

INTERFACE

  USES
    Dialogs,Drivers,
    Parser;

  TYPE

    PVisionParser = ^TVisionParser;
    TVisionParser = object(TDialog)

      TvParser : PVarParser;

      constructor Init;
      destructor  Done; virtual;
      procedure   HandleEvent(var Event:TEvent); virtual;

      function    InitParser : Boolean; virtual;
      procedure   InitMask; virtual;
      procedure   Evaluate; virtual;
      procedure   ShowVars; virtual;

    end;

IMPLEMENTATION

    USES
      Objects,Views,App,
      ParTools;

    CONST
      cmClearVars = 10001;
      cmShowVars  = 10002;
      cmEvaluate  = 10003;

    TYPE

      ExpressionData = record
        Expression : String[44];
        Result     : String[44];
      end;

    constructor TVisionParser.Init;
      var
        R:TRect;
      begin

        R.Assign(0,0,68,12);
        if not inherited Init(R,'Expression Parser') then FAIL;

        Options:=Options or ofCentered;

        if not(InitParser) then FAIL;
        InitMask;
        SelectNext(False);

      end;

    destructor TVisionParser.Done;
      begin
        Dispose(TvParser,Done);
        inherited Done;
      end;

   procedure TVisionParser.HandleEvent(var Event:TEvent);
     begin

       if (Event.What=evCommand) then begin

         case (Event.Command) of

           cmClearVars: TvParser^.ClearVars;
           cmShowVars : ShowVars;
           cmEvaluate : Evaluate;

           else inherited HandleEvent(Event);

         end;
       end else
         inherited HandleEvent(Event);
     end;

  procedure TVisionParser.Evaluate;
    var
      Data:ExpressionData;
      Res : String;

    begin

      GetData(Data);
      str(TvParser^.Evaluate(Data.Expression):42:5,Res);
      Data.Result:=Res;
      SetData(Data);
      DrawView;

    end;

  procedure TVisionParser.ShowVars;
    var
      Coll : PStrColl;

    procedure SetBoxString(PVar:PParserVar);
      var
        S,SVal:String;
      begin

        S:=PVar^.GetName;
        if length(S)>20 then S[0]:=#20 else S:=S+mkStr(20-Length(S),32);

        str(PVar^.GetValue:13:2,SVal);
        S:=S+':'+SVal;

        Coll^.Insert(NewStr(S));

      end;

    var
      R:TRect;
      Dia:PDialog;
      Box:PListBox;
      Scr:PScrollBar;

    begin

      R.Assign(36,1,76,14);
      Dia:=New(PDialog,Init(R,'Varibles'));

      Coll:=New(PStrColl,Init(MaxParserVars,0));

      TvParser^.Vars^.ForEach(@SetBoxString);

      with Dia^ do begin

        R.Assign(37,3,38,9);
        Scr:=New(PScrollBar,Init(R));

        R.Assign(2,3,37,9);
        Box:=New(PListBox,Init(R,1,Scr));
        Box^.NewList(Coll);

        R.Assign(1,2,20,3);
        Insert(New(PLabel,Init(R,'~V~ariable',Box)));

        Insert(Scr);
        Insert(Box);

        R.Assign(2,10,19,12);
        Insert(New(PButton,Init(R,'~O~k',cmOk,bfDefault)));
        R.Move(19,0);
        Insert(New(PButton,Init(R,'E~x~it',cmCancel,bfNormal)));

      end;

      DeskTop^.ExecView(Dia);

      Dispose(Dia,Done);
      Dispose(Coll,Done);

    end;

  function TVisionParser.InitParser : Boolean;
    begin
      TvParser:=New(PVarParser,Init);
      InitParser:=(TvParser<>NIL);
    end;

  procedure TVisionParser.InitMask;
    var
      R:TRect;
      Line:PInputLine;
    begin

      R.Assign(2,3,46,4);
      Line:=New(PInputLine,Init(R,44));
      R.Assign(1,2,20,3);
      Insert(New(PLabel,Init(R,'Ex~p~ression',Line)));
      R.Assign(47,3,50,4);
      Insert(New(PHistory,Init(R,Line,1)));
      Insert(Line);

      R.Assign(2,7,46,8);
      Line:=New(PInputLine,Init(R,44));
      R.Assign(47,7,50,8);
      Insert(New(PHistory,Init(R,Line,2)));
      R.Assign(1,6,20,7);
      Insert(New(PLabel,Init(R,'~R~esult',Line)));
      Line^.Options := Line^.Options or ofSelectable;
      Insert(Line);

      R.Assign(4,9,24,11);
      Insert(New(PButton,Init(R,'~O~k',cmOk,bfNormal)));
      R.Move(22,0);
      Insert(New(PButton,Init(R,'E~x~it',cmCancel,bfnormal)));

      R.Assign(50,3,66,5);
      Insert(New(PButton,Init(R,'~E~valuate',cmEvaluate,bfDefault)));
      R.Move(0,2);
      Insert(New(PButton,Init(R,'~V~ars',cmShowVars,bfNormal)));
      R.Move(0,2);
      Insert(New(PButton,Init(R,'~C~lear',cmClearVars,bfNormal)));

    end;

END.