UNIT PARSER;

{  recursive descent expression Parser.

   Based on the parser by Herbert Shildt as shown in
   Advanced C
   Osborn McGraw-Hill

   Ported to Pascal by

   (C) M.Fiel 1993 Vienna - Austria
   CompuServe ID : 100041,2007

   for further infos refer to this book.

   Use freely if you find it useful.

}
{$R+}

INTERFACE

  USES
    Objects,ParTools;

  CONST
    MaxParserVars = 100; { Max Count of Variables fo PVarParser }

  TYPE

{ PMathParser evaluates expressions like (-(10*5)/27) * 128  no variables }

    PMathParser = ^TMathParser;
    TMathParser = object(TObject)

      ToParse   : PString;    { the string to parse }
      ExprPos   : Integer;    { aktuall position in the string }
      TokenType : Integer;    { Variable delimiter...}
      Token     : String;     { the aktuell token }

      Result    : Real;       { the result of the expression }

      constructor Init;
      destructor  Done; virtual;

      function    Evaluate(Expression:String) : Real;
      { expression is the string which is to be evaluated
      calls function Parse}

      function    GetNextToken : Boolean; virtual;
      function    GetPart : String; virtual;
      function    isDelimiter : Boolean; virtual;

      function    AddSub : Boolean; virtual;
      { checks for Addition or Substr and calls MulDiv }
      function    MulDiv : Boolean; virtual;
      { checks for Multiplikation or Div. and calls Unary }
      function    Unary  : Boolean; virtual;
      { checks for Unary (+/-) and calls Parant }
      function    Parant : Boolean; virtual;
      { checks for paratheses and if necessary calls Parse --> go recursive }

      function    Primitive : Boolean; virtual;
      { evaluates constatn value }

      function    Parse : Boolean; virtual;
      { parse not necessary in this version (call addsub instead) but is
        needed in descents }

    end;

{ VarParser can Handle Variables and epressions like
  A=10.78
  B=20.45
  A*(B-10)+5
  .
  .
  .
}
    PVarParser = ^TVarParser;
    TVarParser = object(TMathParser)

      Vars : PParserVarColl;{Container of Variables defined in Unit ParTools}

      constructor Init;
      destructor  Done; virtual;

      function    Primitive : Boolean; virtual;
      function    Parse : Boolean; virtual;
      { Calls Checckassign }

      function    CheckAssign : Boolean; virtual;
      { checks assignments : ex. A=12 }
      procedure   ClearVars; virtual;
      { clears all variables }

    end;

IMPLEMENTATION

  CONST                { defines wich type a token is }
    tError     = 0;
    tVariable  = 1;
    tDelimiter = 2;
    tNumber    = 3;
    tConstValue = 4;

  constructor TMathParser.Init;
    begin
      if not inherited Init then FAIL;
      ExprPos:=0;
      Token:='';
    end;

  destructor TMathParser.Done;
    begin
      if (ToParse<>NIL) then DisposeStr(ToParse);
      inherited Done;
    end;

  function TMathParser.Evaluate(Expression:String) : Real;

    begin

      if (ToParse<>NIL) then DisposeStr(ToParse);
      ToParse:=NewStr(Expression);

      result:=0.00;
      ExprPos:=1;

      if GetNextToken then Parse;

      Evaluate:=result;

    end;

  function TMathParser.Parse : Boolean;
    begin
      Parse:=AddSub;
    end;

  function TMathParser.GetNextToken : Boolean;
    begin

      GetNextToken:=True;

      while ToParse^[ExprPos] = ' ' do inc(ExprPos);

      if (isDelimiter) then begin

        TokenType := tDelimiter;
        Token:=ToParse^[ExprPos];
        inc(ExprPos);

      end else begin

        case ToParse^[ExprPos] of

          '0'..'9':begin
            TokenType := tNumber;
            Token :=GetPart;
          end;

          'A'..'Z','a'..'z' : begin
            TokenType := tVariable;
            Token:=GetPart;
          end;

          else begin
            TokenType := tError;
            GetNextToken:=False;
          end;

        end;

      end;

    end;

  function TMathParser.GetPart : String;
    var
      RetVal : String;
    begin

      RetVal:='';

      while not(isDelimiter) do begin

        RetVal:=RetVal+ToParse^[ExprPos];

        if ExprPos<length(ToParse^) then
          inc(ExprPos)
        else begin
          RetVal:=Trim(RetVal);
          GetPart:=RetVal;
          Exit;
        end;

      end;

      RetVal:=Trim(RetVal);

      GetPart:=RetVal;

    end;

  function TMathParser.isDelimiter : Boolean;
    begin
      isDelimiter:=(Pos(ToParse^[ExprPos],'+-*/()=%')<>0);
    end;

  function TMathParser.AddSub : Boolean;
    var
      Hold : Real;
      OldToken : String;
    begin

      AddSub:=True;

      if (MulDiv) then begin

        while (Pos(Token,'+-') > 0) do begin

          OldToken:=Token;
          GetNextToken;

          Hold:=Result;

          if (MulDiv) then begin
            if OldToken='+' then Result:=(Hold+Result) else Result:=(Hold-Result);
          end else
            AddSub:=False;

        end;

      end else
        AddSub:=False;

    end;

  function TMathParser.MulDiv : Boolean;
    var
      Hold : Real;
      PerHelp : Real;
      OldToken : String;
    begin

      MulDiv:=True;

      if (Unary) then begin

        while (Pos(Token,'*/%') > 0) do begin

          OldToken:=Token;
          GetNextToken;
          Hold:=Result;

          if (Unary) then begin

            case OldToken[1] of
              '*':Result:=Hold*Result;

              '/':begin
                if (Result<> 0) then
                  Result:=Hold/Result
                else begin
                  OwnError('Division by zero');
                  MulDiv:=False;
                end;
              end;

              '%':begin
                PerHelp:=Hold/Result;
                Result:=Hold-(PerHelp*Result);
              end;

            end;

          end else
            MulDiv:=False;

        end;

      end else
        MulDiv:=False;

    end;

  function TMathParser.Unary : Boolean;
    var
      UnaryHelp:Boolean;
      OldToken : String;
    begin

      Unary:=True;

      UnaryHelp:=False;

      if (Pos(Token,'-+') >0) then begin
        OldToken:=Token;
        UnaryHelp:=True;
        GetNextToken;
      end;

      if (Parant) then begin
        if (UnaryHelp and (OldToken = '-')) then Result:=-(Result);
      end else
        Unary:=False;

    end;

  function TMathParser.Parant : Boolean;
    begin

      Parant:=True;

      if ((TokenType = tDelimiter) and (Token = '(')) then begin

        GetNextToken;

        if (Parse) then begin

          if (Token <> ')') then begin
            OwnError('unbalanced parantheses');
            Parant:=False;
          end;

        end else
          Parant:=False;

        GetNextToken;

      end else

        Parant:=Primitive;

    end;

  function TMathParser.Primitive : Boolean;
    var
      e:Integer;
    begin

      Primitive:=True;

      if (TokenType = tNumber) then begin

        val(Token,Result,e);

        if (e<>0) then begin
          OwnError('syntax error');
          Primitive:=False;
        end;

        GetNextToken;

      end;

    end;


{****************************************************************************}
{                          TVARPARSER                                        }
{****************************************************************************}

  constructor TVarParser.Init;
    begin
      if not inherited Init then FAIL;
      Vars:=New(PParserVarColl,Init(MaxParserVars,0));
    end;

  destructor TVarParser.Done;
    begin
      Dispose(Vars,Done);
      inherited Done;
    end;

  function TVarParser.Primitive : Boolean;
    begin

      Primitive:=True;

      if (inherited Primitive) then begin

        if (TokenType = tVariable) then begin
          result:=Vars^.GetVar(Token);
          GetNextToken;
        end;

      end else
        Primitive:=False;

    end;

 function TVarParser.Parse : Boolean;
   begin
     Parse:=CheckAssign;
   end;

 function TVarParser.CheckAssign : Boolean;
   var
     OldToken : String;
     OldType  : Integer;
   begin

     if (TokenType = tVariable) then begin

       OldToken :=Token;
       OldType := TokenType;

       GetNextToken;

       if (Token = '=') then begin

         GetNextToken;

         CheckAssign:=AddSub;
         Vars^.SetValue(OLdToken,result);

         Exit;

       end else begin

         dec(ExprPos,length(Token));
         Token:=OldToken;
         TokenType:=OldType;

       end;

     end;

     CheckAssign := AddSub;

   end;

 procedure TVarParser.ClearVars;
   begin
     Vars^.FreeAll;
   end;

END.