Program FileDemo;

uses OOPFile;

{ This Program Creates an instance of Record File To Create An object which
  can read/write its own data to standard files. To Implement this program
  on a network RecordFile would be replaced with NetworkFile and the
  ReadFrom / WriteTo Procedures would be used as functions returning True/
  False if the read was successful or not.                                 }

Type
  Data=       Record
                St:  String;
                num: Integer;
              End;

  DataFilePtr=^DataFile;
  DataFile=   Object(RecordFile)
                D:          Data;
                Name:       String;
                NumRecords: Integer;
                Constructor Init(FName: String; NumRec: Integer);
                Procedure CreateFile;
                Procedure Read(RecordNumber: Integer);
                Procedure Write(RecordNumber: Integer);
              End;

Var
  DFile:      DataFilePtr;

Constructor DataFile.Init(FName: String; NumRec: Integer);
Begin
  Name:=FName;
  RecordFile.Init(Name,ReadWrite,SizeOf(D));
  NumRecords:=NumRec;
End;

Procedure DataFile.CreateFile;
Var
  i:   Integer;
Begin
  SetFileMode(Create);
  Open;
  For i:=1 To NumRecords Do
    WriteTo(D,i);
  Close;
  SetFileMode(ReadWrite);
End;

Procedure DataFile.Read(RecordNumber: Integer);
Begin
  Open;
  ReadFrom(D,RecordNumber);
  Close;
End;

Procedure DataFile.Write(RecordNumber: Integer);
Begin
  Open;
  WriteTo(D,RecordNumber);
  Close;
End;

Begin
  New(DFile,Init('TESTFILE.DAT',20));
  DFile^.CreateFile;
  Dispose(DFile,Done);
End.
