{***********************************************************************}
{  Turbo Pascal 6.0                                                     }
{  Buildung Resource File for Bas e                                     }
{  Copyright (c) 1992 B. Plagge                                         }
{ Modifications                                                         }
{ (Error, Correction, Initials, Date, What?                             }
{ E001    BP    18.12.92 Adapt to new system and country record.        }
{               Conditional Compilerdef: EXE : append resource file     }
{               to BASE.EXE                                             }
{***********************************************************************}

program BaseRes;

{ The program builds all the resouces required for the BASE program
  and puts them in a file called BASE.RES.
  Ref. Turbo Vision Guild p. 171                                       }

uses Drivers, Objects, Views, App, Menus, Dialogs,
     BpCtv, BpFld, BpForm, BpSystem, NinMess,
     BaseDlg;


var
 LStrm    : PHaltStream;
 SDialog  : PDialog;
 ResID,
 KeyString: String[20];
 NoRes,
 i        : Integer;
 Lang     : Integer;
 St       : String[3];



procedure InitResource;                {initialize resource file and}
begin                                  {register objects}
{$IFDEF Exe}                           {Exe version: append to BASE.EXE}
  LStrm := New(PHaltStream, Init('BASE.EXE', stOpen, 1024));
{$ELSE}
  LStrm := New(PHaltStream, Init('BASE.RES', stCreate, 1024));
{$ENDIF}
  LRez.Init(LStrm);
  RegisterObjects;
  RegisterViews;
  RegisterMenus;
  RegisterDialogs;
  RegisterApp;
  RegisterCtv;
  RegisterFields;
  RegisterForms;
  RegisterNinMess;
  RegisterBaseDlg;
  RegisterType(RStrListMaker);
end;

procedure CreateSysInfo;
var
  AProg     : PString;
  AVersion  : PString;
  AAuthor   : PString;
  AProgDate : PString;
  ACRec     : PString;
  APrintId  : PString;
  ASound    : Boolean;
  Si        : PSysInfo;
begin
  AProg    := NewStr('BASE');
  AVersion := NewStr('1.00');
  AAuthor  := NewStr('B. PLAGGE');
  AProgDate:= NewStr('19920401');
  ACRec    := NewStr('44COUNTRY');
{ ACRec    := NewStr('49COUNTRY');   }
  APrintId := nil;
  ASound   := True;
  Si := New(PSysInfo, Init(AProg, AVersion, AAuthor, AProgDate,
            ACRec, APrintId, ASound));

  ResId := 'SYSINFO';
  LRez.Put(Si, ResID);
  Dispose(Si, Done);
end;



procedure CreateMessFile;
begin
 case Lang of
   44 : CreateMessageFile(Lang, 'BASE044.MSG');
   49 : CreateMessageFile(Lang, 'BASE044.MSG');
 end;
end;




procedure CreateMenuBar;
var
 MenuBar : PMenuBar;
 R: TRect;
procedure MenuBar44;
begin
  R.Assign(0,0,80,25);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewItem('~S~tart', '', kbNoKey, cmInitDlg, hcNoContext,

    NewSubMenu('~Q~ueries', hcNoContext, NewMenu(
      NewItem('~R~ange', '', kbNoKey, cmQueryRange, hcNoContext,
      NewItem('~W~ildcards', '', kbNoKey, cmQueryPat, hcNoContext,
      NewItem('~P~honetic', '', kbNoKey, cmQueryPhone, hcNoContext,
    nil)))),

    NewSubMenu('~O~ptions', hcNoContext, NewMenu(
      NewItem('~D~b Options', '', kbNoKey, cmOptions, hcNoContext,
      NewSubMenu('~U~tilities', hcNoContext, NewMenu(
        NewItem('Pack ~D~atabase', '', kbNoKey, cmPackDB, hcNoContext,
        NewItem('~R~e-Index', '', kbNoKey, cmReIndex, hcNoContext,
      nil))),                              {submenu utilities}
    nil))),                                {submenu options}

    NewSubMenu('Data E~x~change', hcNoContext, NewMenu(
      NewItem('~E~xport File', '', kbNoKey, cmExportFile, hcNoContext,
      NewItem('~I~mport File', '', kbNoKey, cmImportFile, hcNoContext,
    nil))),                              {submenu data exchange}

    NewSubMenu('~I~nfo', hcNoContext, NewMenu(
      NewItem('~D~B Info', '', kbNoKey, cmDBInfo, hcNoContext,
      NewItem('~R~egistration', '', kbNoKey, cmRegister, hcNoContext,
    nil))),                              {submenu infos}

    nil))))))));                           {end menu}

  ResId:= St + 'MENUBAR';
  LRez.Put(MenuBar, ResID);
  Dispose(MenuBar, Done);
end;

procedure MenuBar49;
begin
end;


begin {CreateMenuBar}
  case Lang of
    44 : MenuBar44;
    49 : MenuBar49;
  end;
end;



procedure CreateStatusLine;
var
  StatusLine: PStatusLine;
  R         : TRect;

procedure StatusLine44;
begin
  R.Assign(0,0,80,25);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
   NewStatusDef(0, $FFFF,
    NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    NewStatusKey('~F10~ Menu', kbF10, cmMenu,
    nil))),
  nil)));

  ResID := St + 'STATUSLINE';
  LRez.Put(StatusLine, ResID);
  Dispose(StatusLine, Done);
end;

procedure StatusLine49;
begin
  R.Assign(0,0,80,25);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
   NewStatusDef(0, $FFFF,
    NewStatusKey('~Alt-X~ Ende', kbAltX, cmQuit,
    NewStatusKey('~F1~ Hilfe', kbF1, cmHelp,
    NewStatusKey('~F10~ Men', kbF10, cmMenu,
    nil))),
  nil)));

  ResID := St + 'STATUSLINE';
  LRez.Put(StatusLine, ResID);
  Dispose(StatusLine, Done);
end;

begin  {CreateStatusLine}
  case Lang of
    44 : StatusLine44;
    49 : StatusLine49;
  end;
end;


procedure CreateInitDlg;
var
  R       : TRect;
  B       : PView;
  Dlg     : PDialog;
  F       : PField;


procedure InitDlg44;
begin
  R.Assign(10,2,70,22);
  Dlg := New(PBaseDlg, Init(R, 'Ninbase Test'));
  with Dlg^ do
  begin
    R.Assign(2,2,15,3);
    Insert(New(PStaticText, Init(R, 'Number:')));
    R.Assign(20,2,27,3);
    F := New(PIntField, Init(R, 5, 0, 99999));
    F^.fOptions := $1;            {required field}
    Insert(F);

    R.Assign(2,4,15,5);
    Insert(New(PStaticText, Init(R, 'Name:')));
    R.Assign(20,4,32,5);
    Insert(New(PInputLine, Init(R, 10)));

    R.Assign(2,6,15,7);
    Insert(New(PStaticText, Init(R, 'First Name:')));
    R.Assign(20,6,32,7);
    Insert(New(PInputLine, Init(R, 10)));

    R.Assign(2,8,15,9);
    Insert(New(PStaticText, Init(R, 'Town:')));
    R.Assign(20,8,32,9);
    Insert(New(PInputLine, Init(R, 10)));

    R.Assign(2,10,15,11);
    Insert(New(PStaticText, Init(R, 'Telefon:')));
    R.Assign(20,10,32,11);
    Insert(New(PInputLine, Init(R, 10)));

    R.Assign(2,13,15,14);
    Insert(New(PStaticText, Init(R, 'File Status:')));
    {This line is used to display the status of the file.
     The ofSelectable bit is cleared so that the line cannot be selected}
    R.Assign(20,13,24,14);
    B := New(PInputLine, Init(R, 2));
    B^.Options := B^.Options and not ofSelectable;
    Insert(B);

    R.Assign(2,14,15,15);
    Insert(New(PStaticText, Init(R, 'Error Type:')));
    {This line is used to display the status of the file.
     The ofSelectable bit is cleared so that the line cannot be selected}
    R.Assign(20,14,26,15);
    B := New(PInputLine, Init(R, 4));
    B^.Options := B^.Options and not ofSelectable;
    Insert(B);

    R.Assign(40,1,57,3);
    Insert(New(PButton, Init(R, '~A~dd Record', cmAddRec, bfNormal)));
    R.Assign(40,3,57,5);
    Insert(New(PButton, Init(R, '~G~et Record', cmGetRec, bfNormal)));
    R.Assign(40,5,57,7);
    Insert(New(PButton, Init(R, '~N~ext Record', cmNextRec, bfNormal)));
    R.Assign(40,7,57,9);
    Insert(New(PButton, Init(R, '~P~rev Record', cmPrevRec, bfNormal)));
    R.Assign(40,9,57,11);
    Insert(New(PButton, Init(R, '~F~irst Record', cmFirstRec, bfNormal)));
    R.Assign(40,11,57,13);
    Insert(New(PButton, Init(R, '~L~ast Record', cmLastRec, bfNormal)));
    R.Assign(40,13,57,15);
    Insert(New(PButton, Init(R, '~U~pdate Record', cmPutRec, bfNormal)));
    R.Assign(40,15,57,17);
    Insert(New(PButton, Init(R, '~D~elete Record', cmDeleteRec, bfNormal)));
    R.Assign(40,17,57,19);
    Insert(New(PButton, Init(R, 'U~n~del. Record', cmUnDelRec, bfNormal)));

    SelectNext(false);
  end;

  ResID := St + 'INITDLG';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;

procedure InitDlg49;
begin
end;

begin {CreateInitDlg}
  case Lang of
    44 : InitDlg44;
    49 : InitDlg49;
  end;
end;


procedure CreateStartDlg;
var
  R       : TRect;
  B       : PView;
  Dlg     : PDialog;

procedure StartDlg44;
begin
  R.Assign(20,5,48,12);
  Dlg := New(PDialog, Init(R, 'Start Options'));
  with Dlg^ do
  begin
    R.Assign(3,3,24,5);
    B := New(PRadioButtons, Init(R,
      NewSItem('Exist. Database',
      NewSItem('New Database',
      nil))
    ));
    Insert(B);
    R.Assign(3,2,25,3);
    Insert(New(PLabel, Init(R, 'Database',B)));
  end;


  ResID := St + 'STARTDLG';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;

procedure StartDlg49;
begin
end;

begin  {CreateStartDlg}
 case Lang of
   44 : StartDlg44;
   49 : StartDlg49;
 end;
end;


procedure CreateNewDbDlg;
var
  R       : TRect;
  B       : PView;
  F       : PField;
  Dlg     : PDialog;

procedure NewDbDlg44;
begin
  R.Assign(12,4,58,17);
  Dlg := New(PDialog, Init(R, 'New database'));
  with Dlg^ do
  begin
    R.Assign(2,3,21,5);
    B := New(PRadioButtons, Init(R,
      NewSItem('Fixed Length',
      NewSItem('Var Length',
      nil))
    ));
    Insert(B);
    R.Assign(2,2,21,3);
    Insert(New(PLabel, Init(R, 'Record Types',B)));

    R.Assign(24,3,44,5);
    B := New(PCheckBoxes, Init(R,
      NewSItem('~B~ackup File',
      NewSItem('~L~ogging',
      nil))
    ));
    Insert(B);
    R.Assign(24,2,44,3);
    Insert(New(PLabel, Init(R, 'Database Options',B)));

    R.Assign(2,7,21,9);
    B := New(PRadioButtons, Init(R,
      NewSItem('String Keys',
      NewSItem('Number Keys',
      nil))
    ));
    Insert(B);
    R.Assign(2,6,21,7);
    Insert(New(PLabel, Init(R, 'Key Types',B)));

    R.Assign(24,7,44,9);
    B := New(PCheckBoxes, Init(R,
      NewSItem('~U~pShift',
      NewSItem('~D~uplicates',
      nil))
    ));
    Insert(B);
    R.Assign(24,6,44,7);
    Insert(New(PLabel, Init(R, 'Key Options',B)));

    R.Assign(27,10,30,11);
    F := New(PIntField, Init(R, 1, 1, 8));
    F^.fOptions := $1;            {required field}
    Insert(F);

    R.Assign(15,10,26,11);
    Insert(New(PLabel, Init(R, 'Key Order',B)));
    SelectNext(false);
  end;

  ResID := St + 'NEWDB';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;

procedure NewDbDlg49;
begin
end;

begin  {CreateStartDlg}
 case Lang of
   44 : NewDbDlg44;
   49 : NewDbDlg49;
 end;
end;


procedure CreateDbOptions;
var
  R       : TRect;
  B       : PView;
  Dlg     : PDialog;

procedure DbOptions44;
begin
  R.Assign(21,5,44,12);
  Dlg := New(PDialog, Init(R, 'Start Options'));
  with Dlg^ do
  begin
    R.Assign(2,3,19,5);
    B := New(PCheckBoxes, Init(R,
      NewSItem('~B~ackup File',
      NewSItem('~L~ogging',
      nil))
    ));
    Insert(B);
    R.Assign(2,2,19,3);
    Insert(New(PLabel, Init(R, 'Database Options',B)));
    SelectNext(false);
  end;

  ResID := St + 'DBOPTIONS';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;

procedure DbOptions49;
begin
end;

begin  {CreatedbOptions}
 case Lang of
   44 : DbOptions44;
   49 : DbOptions49;
 end;
end;


procedure CreateQueryRange;
var
  R       : TRect;
  B       : PView;
  F       : PField;
  Dlg     : PDialog;

procedure Query44;
begin
  R.Assign(23,7,58,12);
  Dlg := New(PDialog, Init(R, 'Retrieve Records'));
  with Dlg^ do
  begin
    R.Assign(3,2,15,3);
    F := New(PField, Init(R, 10));
    Insert(F);
    R.Assign(3,1,15,2);
    Insert(New(PLabel, Init(R, 'From Key',F)));
    R.Assign(20,2,32,3);
    F := New(PField, Init(R, 10));
    Insert(F);
    R.Assign(20,1,32,2);
    Insert(New(PLabel, Init(R, 'To Key',F)));
    SelectNext(false);
  end;


  ResID := St + 'QUERYRANGE';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;

procedure Query49;
begin
end;

begin {CreateQuery}
 case Lang of
   44 : Query44;
   49 : Query49;
 end;
end;


procedure CreateQueryPhone;
var
  R       : TRect;
  B       : PView;
  F       : PField;
  Dlg     : PDialog;

procedure Query44;
begin
  R.Assign(25,7,55,12);
  Dlg := New(PDialog, Init(R, 'Query Records'));
  with Dlg^ do
  begin
    R.Assign(9,2,21,3);
    F := New(PField, Init(R, 10));
    Insert(F);
    R.Assign(9,1,21,2);
    Insert(New(PLabel, Init(R, 'Search Key',F)));
    SelectNext(false);
  end;


  ResID := St + 'QUERYPHONE';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;

procedure Query49;
begin
end;

begin {CreateQuery}
 case Lang of
   44 : Query44;
   49 : Query49;
 end;
end;


procedure CreateList;
var
  R       : TRect;
  B       : PView;
  F       : PField;
  Dlg     : PDialog;

procedure List44;
begin
  R.Assign(1,2,79,21);
  Dlg := New(PDialog, Init(R, 'List Records'));
  with Dlg^ do
  begin
    R.Assign(1,2,8,3);
    Insert(New(PStaticText, Init(R, 'Number')));
    R.Assign(10,2,15,3);
    Insert(New(PStaticText, Init(R, 'Rank')));
    R.Assign(17,2,27,3);
    Insert(New(PStaticText, Init(R, 'Name')));
    R.Assign(29,2,39,3);
    Insert(New(PStaticText, Init(R, 'First Name')));
    R.Assign(41,2,51,3);
    Insert(New(PStaticText, Init(R, 'Town')));
    R.Assign(53,2,63,3);
    Insert(New(PStaticText, Init(R, 'Tel')));
    R.Assign(4,16,10,18);                       {ok and cancel button}
    Insert(New(PButton, Init(R, '~O~K', cmOK, bfDefault)));
    R.Assign(20,16,30,18);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
  end;
  ResID := St + 'LIST';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;


procedure List49;
begin
end;


begin {CreateList}
 case Lang of
   44 : List44;
   49 : List49;
 end;
end;


procedure CreateExport;
var
  R       : TRect;
  B       : PView;
  F       : PField;
  Dlg     : PDialog;

procedure Export44;
begin
  R.Assign(10,2,70,17);
  Dlg := New(PDialog, Init(R, 'Export Records'));
  with Dlg^ do
  begin
    R.Assign(3,2,40,3);
    Insert(New(PStaticText, Init(R,
     'Field  NinBase   dBase   Length')));

    R.Assign(3,4,40,5);
    Insert(New(PStaticText, Init(R,
     'Number LongInt     N        5')));

    R.Assign(3,5,40,6);
    Insert(New(PStaticText, Init(R,
     'Name   PString     C       10')));

    R.Assign(3,6,40,7);
    Insert(New(PStaticText, Init(R,
     'FName  PString     C       10')));

    R.Assign(3,7,40,8);
    Insert(New(PStaticText, Init(R,
     'Town   PString     C       10')));

    R.Assign(3,8,40,9);
    Insert(New(PStaticText, Init(R,
     'Tel    PString     N       10')));

    R.Assign(42,3,52,4);
    F := New(PField, Init(R, 8));
    Insert(F);
    R.Assign(42,2,52,3);
    Insert(New(PLabel, Init(R, 'File Name',F)));

    R.Assign(42,5,57,6);
    B := New(PCheckBoxes, Init(R,
      NewSItem('~S~DF File',
      nil)
    ));
    Insert(B);

    R.Assign(45,8,48,9);
    F := New(PField, Init(R, 1));
    Insert(F);
    R.Assign(42,7,52,8);
    Insert(New(PLabel, Init(R, 'Delimiter', F)));

    R.Assign(4,12,14,14);                       {ok and cancel button}
    Insert(New(PButton, Init(R, '~S~tart', cmOK, bfDefault)));
    R.Assign(20,12,30,14);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
    SelectNext(false);
  end;
  ResID := St + 'EXPORT';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;


procedure Export49;
begin
end;


begin {CreateExport}
 case Lang of
   44 : Export44;
   49 : Export49;
 end;
end;


procedure CreateImport;
var
  R       : TRect;
  B       : PView;
  F       : PField;
  Dlg     : PDialog;

procedure Import44;
begin
  R.Assign(10,2,70,17);
  Dlg := New(PDialog, Init(R, 'Import Records'));
  with Dlg^ do
  begin
    R.Assign(20,2,55,3);
    Insert(New(PStaticText, Init(R,
     'Field  NinBase   dBase   Length')));

    R.Assign(20,4,55,5);
    Insert(New(PStaticText, Init(R,
     'Number LongInt     N        5')));

    R.Assign(20,5,55,6);
    Insert(New(PStaticText, Init(R,
     'Name   PString     C       10')));

    R.Assign(20,6,55,7);
    Insert(New(PStaticText, Init(R,
     'FName  PString     C       10')));

    R.Assign(20,7,55,8);
    Insert(New(PStaticText, Init(R,
     'Town   PString     C       10')));

    R.Assign(20,8,55,9);
    Insert(New(PStaticText, Init(R,
     'Tel    PString     N       10')));

    R.Assign(3,3,13,4);
    F := New(PField, Init(R, 8));
    Insert(F);
    R.Assign(3,2,13,3);
    Insert(New(PLabel, Init(R, 'File Name',F)));

    R.Assign(3,5,18,6);
    B := New(PCheckBoxes, Init(R,
      NewSItem('~S~DF File',
      nil)
    ));
    Insert(B);

    R.Assign(6,8,9,9);
    F := New(PField, Init(R, 1));
    Insert(F);
    R.Assign(3,7,13,8);
    Insert(New(PLabel, Init(R, 'Delimiter', F)));

    R.Assign(20,12,30,14);                       {ok and cancel button}
    Insert(New(PButton, Init(R, '~S~tart', cmOK, bfDefault)));
    R.Assign(40,12,50,14);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
    SelectNext(false);
  end;
  ResID := St + 'IMPORT';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;


procedure Import49;
begin
end;


begin {CreateImport}
 case Lang of
   44 : Import44;
   49 : Import49;
 end;
end;


procedure CreateDBInfo;
var
  R       : TRect;
  B       : PView;
  F       : PField;
  Dlg     : PDialog;

procedure DbInfo44;
begin
  R.Assign(11,2,59,19);
  Dlg := New(PDialog, Init(R, 'Database Info'));
  with Dlg^ do
  begin
    R.Assign(2,2,39,3);
    F := New(PField, Init(R, 35));
    Insert(F);

    R.Assign(41,2,47,3);
    F := New(PField, Init(R, 4));
    Insert(F);

    R.Assign(2,5,21,7);
    B := New(PRadioButtons, Init(R,
      NewSItem('Fixed Length',
      NewSItem('Var Length',
      nil))
    ));
    Insert(B);
    R.Assign(2,4,21,5);
    Insert(New(PLabel, Init(R, 'Record Types',B)));

    R.Assign(24,5,44,7);
    B := New(PCheckBoxes, Init(R,
      NewSItem('~B~ackup File',
      NewSItem('~L~ogging',
      nil))
    ));
    Insert(B);
    R.Assign(24,4,44,5);
    Insert(New(PLabel, Init(R, 'Database Options',B)));

    R.Assign(2,9,21,11);
    B := New(PRadioButtons, Init(R,
      NewSItem('String Keys',
      NewSItem('Number Keys',
      nil))
    ));
    Insert(B);
    R.Assign(2,8,21,8);
    Insert(New(PLabel, Init(R, 'Key Types',B)));

    R.Assign(24,9,44,11);
    B := New(PCheckBoxes, Init(R,
      NewSItem('~U~pShift',
      NewSItem('~D~uplicates',
      nil))
    ));
    Insert(B);
    R.Assign(24,8,44,9);
    Insert(New(PLabel, Init(R, 'Key Options',B)));

    R.Assign(30,12,33,13);
    F := New(PIntField, Init(R, 1, 1, 8));
    F^.fOptions := $1;            {required field}
    Insert(F);

    R.Assign(17,12,28,13);
    Insert(New(PLabel, Init(R, 'Key Order',B)));

    R.Assign(14,14,20,15);
    F := New(PIntField, Init(R, 4, 1, 8));
    F^.fOptions := $1;            {required field}
    Insert(F);

    R.Assign(2,14,13,15);
    Insert(New(PLabel, Init(R, 'No of Recs',B)));

    R.Assign(34,14,40,15);
    F := New(PIntField, Init(R, 4, 1, 8));
    F^.fOptions := $1;            {required field}
    Insert(F);

    R.Assign(22,14,33,15);
    Insert(New(PLabel, Init(R, 'No of Dels',B)));
    SelectNext(false);
    SelectNext(false);
    SelectNext(false);
  end;

  ResID := St + 'DBINFO';
  LRez.Put(Dlg, ResID);
  Dispose(Dlg, Done);
end;

procedure DbInfo49;
begin
end;

begin  {CreateDBInfo}
 case Lang of
   44 : DbInfo44;
   49 : DbInfo49;
 end;
end;


procedure DisplayInfo;                 {display key of resources in file}
begin
  NoRes := LRez.Count;

  for i := 0 to Pred(NoRes) do
    begin
      KeyString := LRez.KeyAt(i);
      writeln (KeyString);
    end;

  LRez.Done;
end;




begin   {LearnRez}                               {call procedures for creating res.}
  InitResource;

  CreateSysInfo;

for Lang := 44 to 49 do
begin
  Co := nil;
  Str(Lang, St);
  CreateCountryInfo(Lang, Co);
  CreateMessFile;

  CreateMenuBar;
  CreateStatusLine;
  CreateInitDlg;
  CreateStartDlg;
  CreateNewDbDlg;
  CreateDbOptions;
  CreateQueryRange;
  CreateQueryPhone;
  CreateList;
  CreateExport;
  CreateImport;
  CreateDbInfo;
  if (Co <> nil) then
    Dispose(Co);
end;

  DisplayInfo;
end.


