(*
  This program demonstrates the memory mapped box routines
  contained in BOX.INC, plus the screen save/restore routines
  declared in SAVESCRN.INC.

  In this program, screen updates are done by updating the video RAM
  directly, so movement such as exploding windows can be shown.

  See FS.PAS for an equivalent version which uses delayed updates.
*)
{$I SAVESCRN.INC}
{$I BOX.INC}
var
  SaveBuf:array[1..4000] of byte;
  SaveX,SaveY:integer;
begin
  SaveX:=WhereX;
  SaveY:=WhereY;
  SaveScreen(SaveBuf);
  expandbox(5,5,75,20,256,white);
  delay(1000);
  {On monochrome the most reliable way to get reverse video is $70}
  if Mem[0:$449]=7 then
   explodebox(10,1,70,25,256,$70)
  else
   explodebox(10,1,70,25,256,blue shl 4);
  delay(1000);
  {This is a good way to clear the interior when not exploding}
  window(20,12,60,18);
  clrscr;
  box(20,12,60,18,2,Red+128);
  gotoxy(8,3); {Co-ordinates relative to window}
  TextColor(red);
  TextBackground(black);
  write('Hit any key to continue');
  repeat until keypressed;
  RestoreScreen(SaveBuf);
  Window(1,1,80,25);
  GotoXY(SaveX,SaveY);
end.
