(*
  This program demonstrates the memory mapped box routines
  contained in FS.INC, plus the screen save/restore routines
  declared in SAVESCRN.INC.

  With these routines, changes are made in an unseen buffer and
  block transferred to to video RAM, so the actual screen updates
  appear simultaneously.

  See BOX.PAS for an equivalent version which updates video RAM
  as you go along.
*)
{$I SAVESCRN.INC}
{$I FS.INC}
var
  SaveBuf:array[1..4000] of byte;
  Scr:ScreenBuf;
  SaveX,SaveY:byte;
begin
  WaitForRetrace:=not EGA_Installed;
  SaveX:=WhereX;
  SaveY:=WhereY;
  SaveScreen(SaveBuf);
  move(SaveBuf,Scr,4000); {To overlay what is already on the screen.}
  BufBox(Scr,5,5,75,20,256,white);
  {Clear interior of box. Note co-ordinate change from box.}
  {This was not needed in BOXDEMO since exploding clears interior.}
  ClrWindowBuf(Scr,5+1,5+1,75-1,20-1,' ',green);
  RestoreScreen(Scr); {Show what we have so far}
  delay(1000);
  {On monochrome the most reliable way to get reverse video is $70}
  if Mem[0:$449]=7 then
   begin
    {Order of clearing and framing does not matter.}
    {All changes show at the same time.}
    ClrWindowBuf(Scr,10+1,1+1,70-1,25-1,' ',$70);
    BufBox(Scr,10,1,70,25,256,$70);
   end
  else
   begin
    ClrWindowBuf(Scr,10+1,1+1,70-1,25-1,' ',blue shl 4);
    BufBox(Scr,10,1,70,25,256,blue shl 4);
   end;
  RestoreScreen(Scr);
  delay(1000);
  ClrWindowBuf(Scr,20+1,12+1,60-1,18-1,' ',red);
  BufBox(Scr,20,12,60,18,2,Red+128); {+128 for blinking}
  {Co-ordinates are always relative to the whole screen}
  {Add top left corner of box to postion relative to "window"}
  ScreenPut(Scr,'Hit any key to continue',20+8,12+3,red);
  RestoreScreen(Scr);
  repeat until keypressed;
  RestoreScreen(SaveBuf);
  GotoXY(SaveX,SaveY);
end.
