(* Screen buffer routines intended for use with 'RestoreScreen'.*)
(* Global reference: WaitForRetrace (by ScreenPutX only) *)
type ScreenBuf=array[1..25,1..80] of record ch: char; at:byte; end;
type ScreenStr=string[255];

{ Fill a box within a buffer with a given char and attribute.}
procedure ClrWindowBuf(var scr:ScreenBuf; x1,y1,x2,y2:byte;
 fillval:char; attr:byte);
var i,j:integer;
begin
 for i:=y1 to y2 do
  for j:=x1 to x2 do
   begin
    scr[i,j].ch:=fillval;
    scr[i,j].at:=attr;
   end;
end;

{Fill the entire buffer with a given character and attribute.}
procedure ClrScreenBuf(var scr:ScreenBuf; fillval:char; attr:byte);
begin
 ClrWindowBuf(scr,1,1,80,25,fillval,attr);
end;

{ Put a string into a screen buffer, with attributes.}
procedure ScreenPut(var scr:ScreenBuf; str:ScreenStr;x,y,attr:byte);
var i:byte;
begin
 for i:=1 to ord(str[0]) do
  begin
   scr[y,x].ch:=str[i];
   if attr<>0 then scr[y,x].at:=attr;
   x:=x+1;
   if x>80 then begin x:=1; y:=y+1; end; {handles line wrap}
  end;
end; {ScreenPut}

{ Get a string from a screen buffer, without attributes.}
{ Could pass address of actual video memory.            }
function ScreenGet(var scr:ScreenBuf; x,y,len:byte):ScreenStr;
var i:byte;
begin
 ScreenGet[0]:=chr(len);
 for i:=1 to len do
  begin
   ScreenGet[i]:=scr[y,x].ch;
   x:=x+1;
   if x>80 then begin x:=1; y:=y+1; end; {handles line wrap}
  end;
end; {ScreenPut}

{ Draw a box in a screen buffer.                                    }
procedure BufBox(var buf:ScreenBuf;
  TopLeftX,TopLeftY,BottomRightX,BottomRightY:integer;
  boxchar:integer;attr:byte);
var
 i:integer;
 tl,tr,bl,br,hl,vl:char;
begin
  case boxchar of
  256: {similarly define a box out of any characters you like}
    begin
      tl:=chr(218); {top left corner}
      tr:=chr(191); {top right corner}
      bl:=chr(192); {bottom left corner}
      br:=chr(217); {bottom right corner}
      hl:=chr(196); {horizontal line}
      vl:=chr(179); {vertical line}
    end;
  else {all parts of box use the character given, 0 thru 255}
    tl:=chr(boxchar); {top left corner}
    tr:=chr(boxchar); {top right corner}
    bl:=chr(boxchar); {bottom left corner}
    br:=chr(boxchar); {bottom right corner}
    hl:=chr(boxchar); {horizontal line}
    vl:=chr(boxchar); {horizontal line}
  end;
  buf[TopLeftY,TopLeftX].ch:=tl;
  buf[TopLeftY,BottomRightX].ch:=tr;
  buf[BottomRightY,TopLeftX].ch:=bl;
  buf[BottomRightY,BottomRightX].ch:=br;
  buf[TopLeftY,TopLeftX].at:=attr;
  buf[TopLeftY,BottomRightX].at:=attr;
  buf[BottomRightY,TopLeftX].at:=attr;
  buf[BottomRightY,BottomRightX].at:=attr;
  for i:=TopLeftX+1 to BottomRightX-1 do
    begin
      buf[TopLeftY,i].ch:=hl;
      buf[BottomRightY,i].ch:=hl;
      buf[TopLeftY,i].at:=attr;
      buf[BottomRightY,i].at:=attr;
    end;
  for i:=TopLeftY+1 to BottomRightY-1 do
    begin
      buf[i,TopLeftX].ch:=vl;
      buf[i,BottomRightX].ch:=vl;
      buf[i,TopLeftX].at:=attr;
      buf[i,BottomRightX].at:=attr;
    end;
end; {BoxBuf}

procedure ScreenPutX(str:ScreenStr;X,Y,attr:byte);
var
 tbuf:array[1..255] of record ch:char; at:byte; end;
 i:integer;
begin
 for i:=1 to ord(str[0]) do
  begin
   tbuf[i].ch:=str[i];
   tbuf[i].at:=attr;
  end;
 if Mem[0:$449]=7 then
  move(tbuf,Mem[$B000:2*(X+80*Y-81)],2*ord(str[0]))
 else
  begin
   if WaitForRetrace then
    begin
     while (port[$3DA] and $80)=0 do;
     port[$3D8]:=$21;
    end;
   move(tbuf,Mem[$B800:2*(X+80*Y-81)],2*ord(str[0]));
   if WaitForRetrace then
    port[$3D8]:=$29;
  end;
end;
