unit Picks;
(***************************************************************************
                 Implements a generic PickList Object.
            Copyright 1992 Cybersoft - All Rights Reserved.
 ***************************************************************************)

(*
Generic PickList.

  The PickList is Init'ed with values for a TREct that are used to compute
  the other TRect values for the scroller, listbox, and buttons.

sample useage:
type
     { Used for Sorted list, maintaining record of unsorted position. }
     TSortRecord = record
       Name : String [50];
       RecNum : integer;
     end;

     POurList = ^TOurList;
     TOurList = object (TSortedCollection)
       function Compare (Key1, Key2 : Pointer): Integer; virtual;
       procedure FreeItem (Item : Pointer); virtual;
     end;

     POurListBox = ^TOurListBox;
     TOurListBox = object (TSortedListBox)        {from StdDlg}
       procedure HandleEvent (var Event : TEvent); virtual;
       function GetText (Item : Integer; MaxLen : Integer) : String; virtual;
     end;



function PickIt (var which : integer) : boolean;
var
    OurList           : POurList;
    OurRecord         : TSortRecord;      { for records other than PStrings }
    ListBox           : POurListBox;      { Optional }
    OurScroller       : PView;            { Optional }
    ItemNum           : Integer;

begin
           { Must be done first -- sets value for the dialog's TRect }
   New(OurPickList, Init(9,3,70,17));

           { Optional -- nil can be passed to ListItemPicked. }
   OurScroller := New(PScrollbar, Init(ScrollBarTRect));
           { Optional  -- nil can be passed to ListItemPicked. }
   ListBox := New(POurListBox, Init(ListBoxTRect, 1, PScrollbar(OurScroller)));


           { This is a procedure you write.            }
           { Builds a PCollection or PSortedCollection.}
   BuildSortedList (OurList);

   if OurPickList^.ListItemPicked(OurScroller, ListBox, OurList,
                                  'Pick Something', ItemNum) then
   begin
     PickIt := true;
     OurRecord := PSortRecord(OurList^.At(ItemNum))^;
     which := OurRecord.RecNum;
   end;

   Dispose (OurList, Done);
   OurList := nil;
   Dispose (OurPickList, Done);
end;
*)



interface
uses Objects, Views, Dialogs, Drivers, App, MsgBox, StdDlg;

type
  PPickDialog = ^TPickDialog;
  TPickDialog = object(TDialog)
    Focused : Integer;
    ListBox : PListBox;
    procedure HandleEvent(var Event : TEvent);virtual;
  end;


  PPickList = ^TPickList;
  TPickList = object(TObject)
    R             : TRect;
    List          : PCollection;

    constructor Init (XA, YA, XB, YB : Integer);

    function ListItemPicked( OurScroller : PView;
                             OurListBox  : PListBox;
                             OurList     : PCollection;
                             Title       : String;
                             var ItemNum : Integer):boolean;
  private
    function CreatePickList( OurScroller : PView;
                             OurListBox  : PListBox;
                             OurList     : PCollection;
                             Title       : string) : PPickDialog;

  end;

  PRect = ^TRect;

  var ScrollBarPRect,
      ListBoxPRect : PRect;
      
implementation (***********************************************************)

{***************************** TPickDialog *********************************}

procedure TPickDialog.HandleEvent(var Event: TEvent);
begin
  Focused := ListBox^.Focused;
  if ListBox^.MouseInView(MouseWhere) and
           (Event.What = evMouseDown) and
           (Event.Double = true) then
    EndModal(cmOK);
  TDialog.HandleEvent(Event);
end;




{************************** TPickList *************************************}

constructor TPickList.Init (XA, YA, XB, YB : Integer);
begin
  TObject.Init;
  R.Assign (XA, YA, XB, YB);
  ListBoxPRect^.Assign (3, 2, ((R.B.X - R.A.X) - 4), ((R.B.Y - R.A.Y) - 4));
  ScrollBarPRect^.Assign (ListBoxPRect^.B.X, 2, ListBoxPRect^.B.X + 1,
                         ListBoxPRect^.B.Y);
end;


function TPickList.CreatePickList( OurScroller : PView;
                                   OurListBox  : PListBox;
                                   OurList     : PCollection;
                                   Title       : string) : PPickDialog;
var
  Dlg                   : PPickDialog;
  Control, Labl,
  Histry                : PView;
  AScroller             : PView;
  OurR                  : TRect;

Begin
{R.Assign(6,3,73,21);}
New(Dlg, Init(R, Title));

if OurScroller = nil then
begin
  AScroller := New(PScrollbar, Init(ScrollBarPRect^));
  Dlg^.Insert(AScroller);
end
else
  Dlg^.Insert(OurScroller);


OurR.Assign(
            ((R.B.X - R.A.X) - 26),
            ((R.B.Y - R.A.Y) - 3),
            ((R.B.X - R.A.X) - 16),
            ((R.B.Y - R.A.Y) - 1)
            );
Control := New(PButton, Init(OurR, ' OK', cmOK, bfDefault));
Dlg^.Insert(Control);

OurR.Assign(
            ((R.B.X - R.A.X) - 13),
            ((R.B.Y - R.A.Y) - 3),
            ((R.B.X - R.A.X) - 3),
            ((R.B.Y - R.A.Y) - 1)
            );
Control := New(PButton, Init(OurR, 'Cancel', cmCancel, bfNormal));
Dlg^.Insert(Control);

if OurListBox = nil then
  Dlg^.ListBox := New(PListBox, Init(ListBoxPRect^, 1, PScrollbar(OurScroller)))
else
  Dlg^.ListBox := OurListBox;
Dlg^.ListBox^.NewList(OurList);
Dlg^.Insert(Dlg^.ListBox);

CreatePickList := Dlg;

end;




function TPickList.ListItemPicked(OurScroller : PView;
                                  OurListBox  : PListBox;
                                  OurList     : PCollection;
                                  Title       : String;
                                  var ItemNum : Integer):boolean;
var D   : PPickDialog;
    cmd : word;
begin
  ListItemPicked := false;
  if OurList = nil then exit;
  D := CreatePickList(OurScroller, OurListBox, OurList, Title);
  cmd := Desktop^.ExecView(D);
  if cmd = cmOK then begin
    ListItemPicked := true;
    ItemNum := D^.Focused;
  end;
  Dispose(D, Done);
end;



{--------------------------------------------------------------------------}

begin
  New (ListBoxPRect);
  New (ScrollBarPRect);
  ListBoxPRect^.Assign(0,0,0,0);
  ScrollBarPRect^.Assign(0,0,0,0);
end.