PROGRAM CountPagesAndLines;         {What the program does.                }
CONST
     ProgData = 'FPALN- Free DOS utility: text file page & line counter.';
     ProgDat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

     Usage  = 'Usage: FPALN text_file [/t (file Totals only)]';

VAR
     PagedFile    : Text;           {The actual file to dissect (examine). }
     PS1          : String[80];     {The name of the file.                 }
     ALine        : String;         {A line in the file.                   }
     FFCount,                       {Count of FormFeeds (), ASCII 12      }
     TotalLines,                    {Total lines in the file.              }
     LineCount    : Word;           {Total lines on each page.             }
     JustTotals   : Boolean;        {Indicator of how much info to write.  }


PROCEDURE WritePageStats;     {Called at end of every page to show subtotals.}
BEGIN                         {Do nothing if instructed to only show totals. }
     IF (NOT JustTotals) THEN             {Otherwise, go ahead.}
        WriteLn('Page: ',FFCount:7,' has: ',LineCount:5,' lines.');
END;

BEGIN
     Writeln(ProgData);
     Writeln(ProgDat2);
     Writeln;
     FFCount := 0;
     TotalLines := 0;                              {Initialize all counts.}
     LineCount := 0;
     JustTotals := (ParamStr(2) = '/t');           {Just show totals if   }
                                                   {  2nd parameter is /t.}
     PS1 := ParamStr(1);                           {PS1 gets command line.}

     WHILE PS1 = '' DO BEGIN
        Writeln('Text file to dissect:');          {   Recursive query.   }
        ReadLn(PS1);
     END;

     Assign(PagedFile,PS1);                        {  Assign properly.    }
{$I-} Reset(PagedFile); {$I+}                      { Check if file exists.}
     IF IOResult <> 0 THEN                         { If it                }
     BEGIN                                         {    doesn't, then     }
         Writeln('I cannot open "', PS1, '".');    {  quit with message.  }
         Writeln(Usage);
         Halt;
     END;
     WHILE NOT Eof(PagedFile) DO                   {Will read             }
     BEGIN                                         {     the entire file. }
          ReadLn(PagedFile,ALine);                 {Read a line.          }
          TotalLines := Succ(TotalLines);          {Increment counter.    }
          IF Pos('',ALine) <> 0 THEN              {If page break on line,}
          BEGIN                                    {increment page counter.}
             FFCount := Succ(FFCount);             {If page break in the  }
             IF Pos('',ALine) > 1 THEN            {   middle of line,    }
             BEGIN                                 {     the line would   }
                TotalLines := Succ(TotalLines);    {       print over two }
                LineCount := Succ(LineCount);      { lines, so increment  }
             END;                                  { line counters again. }
             WritePageStats; {A procedure, above.} {Write totals so far.  }
             LineCount := 0;                       {Reset counter for     }
          END;                                     {    next page.        }
          LineCount := Succ(LineCount);            {The line in buffer    }
     END;                                          { automatically counts.}
     IF (TotalLines <> 0) THEN                     {If no lines,          }
        FFCount := Succ(FFCount);                  {        then no pages!}
     WritePageStats;                               {Write totals so far.  }
     WriteLn;                           {These next lines write grand totals.}
     Write('Text file ',PS1:13,'  has: ',TotalLines:7,' lines on: ',FFCount:5);
     IF FFCount <> 1 THEN                    {If zero pages, OR multiple    }
        WriteLn(' pages.')                   {        pages, write "pages." }
     ELSE                                    {otherwise,                    }
        WriteLn(' page.');                   {        simply write "page."  }
     Close (PagedFile);                      {Close our file for neatness.  }
END.                                         {          Done!!!             }
