Unit Env;

Interface
Function Environment (ParamString : String) : String;

Implementation

Function Environment (ParamString : String) : String;
VAR
 EnvironmentSegment : Integer;
 MemOffset : Integer;
 Loc,
 MemValue : Byte;
 LeftSide,
 RightSide : String;
 NoMoreParams,
 EqualSignFound : Boolean;

BEGIN
  EnvironmentSegment := MemW[PrefixSeg:$002C];
  NoMoreParams := False;
  MemOffset := 0;

For Loc := 1 to Length(ParamString) DO
  ParamString[Loc] := UpCase(ParamString[Loc]);

REPEAT
  LeftSide[0] := #0;
  RightSide[0] := #0;
  EqualSignFound := False;

  MemValue := Mem[EnvironmentSegment:MemOffset];
  Inc(MemOffset);
  NoMoreParams := (Memvalue = 0);

  While (MemValue <> 0) DO
    BEGIN
      If (Chr(MemValue) = '=') THEN
        EqualSignFound := True
      ELSE
        If EqualSignFound THEN
          RightSide := RightSide + Chr(MemValue)
        ELSE
          LeftSide := LeftSide + Chr(MemValue);

      MemValue := Mem[EnvironmentSegment:MemOffset];
      Inc(MemOffset);
    END;
  UNTIL ((LeftSide = ParamString) OR NoMoreParams);
  Environment := RightSide;
END;
END.

