program testdata;

uses
  crt,
  qwik,     {The regular Qwik utils}
  strs,
  wndw,
  Wutil,
  goof,
  entrdata;   {The Data entry unit}

{$F+}
procedure KbdIdle;
begin
end;
{$F-}

{$F+}
procedure BadEntry;
{ Example of procedure that can get called if they enter bad
  data (ie, "1.2." for a real)}
begin
  MakeWindow(0,0,3,17,White+RedBG,White+RedBG,EvenSolidBrdr,aWindow);
  WWriteC(1,'Invalid entry');
  sound(200);
  delay(200);
  nosound;
  delay(1500);
  RemoveWindow;
end;
{$F-}

procedure SetDataEntryDefaults;
{This procedure must be included and called by the program using entrdata.
 The default colors and other entrdata settings are specified here.}
begin
  {First, the default colors for field input, output}
  if QvideoMode=Mono then
    begin
      DataEntryIattr := LightGray; { Input  attribute : when editing field}
      DataEntryOattr := White;     { Output attribute : normal field display}
      {Optional Attribute of Data Entry hilite when using EnterSeq. Hilites
      field when selected before CR is hit to edit. Use SameAttr if not desired}
      DataPad.Hattr  := LightGrayBG;
    end
  else
    begin
      DataEntryIattr := Yellow+MagentaBG;  { Input  attribute }
      DataEntryOattr := Black+LightGrayBG; { Output attribute }
      DataPad.Hattr  := White+CyanBG;
    end;

  {The address of a FAR procedure can be assigned here to point to
   error handler procedure if data entry error. (defaults to nil = none)}

  DataPad.ErrHandlerProc:=@BadEntry;

  {The following typed constants can be changed interactively by program.}

  AutoTab := true;    {After sequential entry, tab to next one in sequence }

  AutoNumLock:=false; {sets num lock on for numeric data entry}

  {DataWriteMode: ScrnRel (default) forces DataIO routines write to screen
   relative Row & Col, and WndwRel causes it to use window relative coords.}

  { DataWriteMode:=WndwRel; }

  SeqDoneKey := F10Key; {This is the function key to end sequencial data entry}

end;


{Example follows}

var
  MyEntries : DEGroupRec;  {Our local group of data entry records}
type
  { Our local data entry names }
  MyEntryNames = (NoDE,aIntegerDE,aRealDE,aStringDE);
                { ^^^^ First must ALWAYS be a dummy }

const {TEST}
  aReal:    real    = 1.234;
  aInteger: integer = 200;
  aString : string[50] = 'This is a nice long string.';


{$F+}
procedure VerifyAinteger;
const
  OopsMsg = 'OOPS - that''s > 500';
begin
  with DataPad do
    if Idata>500 then
      begin
        QWrite(20,1,SameAttr,OopsMsg);
        delay(2000);
        QFill(20,1,1,length(OopsMsg),SameAttr,' ');
        RangeOK:=false;
      end;
end;
{$F-}

{$F+}
procedure TranslateCase;
begin
  if not ExtKey then
    Key:=upcase(Key);
end;
{$F-}

procedure SetMyDataEntries;
{User defined procedure to setup all data entries in a group.}
begin
  with TopEntry do
    begin
      GetDataEntry (MyEntries,ord(aIntegerDE)); {Allocate the entry rec}
      VarAddr     := @aInteger;                 {Assign variable address}
      TypeOfData  := Integers;                  {Specify type of data}
      Row         := 5;                  {Row & column for data}
      Col         := 10;                 {DataWriteMode sets Scrn vs Wndw rel}
      Field       := 4;                  {Field will display this many chars}
      CheckRangeProc := @VerifyAinteger; {User defined range check proc}
      SaveDataEntry;

      GetDataEntry (MyEntries,ord(aRealDE));
      VarAddr     := @aReal;
      TypeOfData  := Reals;
      SetName     := RealSet;            {set of valid input chars}
      Row         := 6;
      Col         := 10;
      Field       := 7;
      Decimals    := 3;
      SaveDataEntry;

      GetDataEntry (MyEntries,ord(aStringDE));
      VarAddr     := @aString;
      TypeOfData  := Strings;
      SetName     := CharSet;
      Row         := 7;
      Col         := 10;
      Field       := 20;
      MaxField    := pred(sizeof(aString)); {will scroll to accept this many}
      TranslateProc := @TranslateCase;      {User defined xlate proc}
      SaveDataEntry;

    end;
end;  { procedure SetMyDataEntries }


var
  StartField : word;

BEGIN {Main block}
  InitWindow(LightGray+BlueBG,true); {Not necessary for using entrdata}
  Qwrite(2,10,SameAttr,'Use F10 to exit.');
  AddrKbdIdle:=@KbdIdle;
  SetDataEntryDefaults;
  AllocateDataEntries(MyEntries,ord(aStringDE)); {ord of last = # of entries}
  SetMyDataEntries;
  DisplayFields(MyEntries,ord(aIntegerDE),ord(aStringDE));
  StartField:=ord(aIntegerDE);
  EnterSeq(MyEntries,ord(aIntegerDE),ord(aStringDE),StartField);
  RemoveDataEntries(MyEntries); {Free the space used for local DEs}
  GotoRC(24,1);
  SetCursor(CursorInitial);
END.

