{ ================================================================
                     DEMO PROGRAM

  Asks for a small array (simply to keep the demo reasonably
  short), then has user enter strings into it interactively.

  Displays them, then deallocates the object and prints memory
  statistics.

  ================================================================ }
USES WinCRT, dynstr1;

VAR
  Buf : PTLABuffer;
  BufSize : WORD;
  membefore, memduring, memafter : LONGINT;

  i : WORD;
  s : STRING;

BEGIN
  ClrScr;

  { # of items to allocate for this example.  Ask for a small amount,
    since the strings are entered interactively. }
  Write('# of elements in array (3 or 4 suggested): ');
  ReadLn(i);

  { Get memory available before anything happens. }
  membefore := MemAvail;

  { Allocate the empty lookahead buffer. It doesn't have an array yet. }
  New(Buf, Init(i));

  { Get memory after everything was allocated. }
  memduring := MemAvail;

  { Ensure nothing went awry. }
  IF Buf^.Error THEN
    BEGIN
      WriteLn('Unable to allocate a PLABuffer object. Quitting.');
      { Exit to OS, setting error code to 1. }
      Halt(1);
    END;

  { Fill the array interactively. }
  FOR i := 0 TO PRED(Buf^.BufSize) DO
    BEGIN
      { Get a string. }
      Write('Please enter string #', i+1, ' of ', Buf^.NumOfElements,': ');
      ReadLn(s);
      { Write it to the array. }
      Buf^.WriteElement(i, s);
    END;

  WriteLn; WriteLn;

  { Print back everything that was entered. }
  FOR i := 0 TO PRED(Buf^.BufSize) DO
    BEGIN
      WriteLn(Buf^.ReadElement(i));
    END;

  WriteLn('# of elements in array:                 ', Buf^.NumOfElements);

  { Return all memory to operating system. }
  Dispose(Buf, Done);

  memafter := MemAvail;

  WriteLn('Memory before allocating buffer:        ', membefore);
  WriteLn('Memory after allocating buffer:         ', memduring);
  WriteLn('Memory before deallocating buffer       ', memafter);
  WriteLn('Difference:                             ', membefore - memafter);
  WriteLn('Size of allocated object was:           ', membefore - memduring);


END.

