program helpconv;
Uses
   Crt;

{
 Converts 65 char per line help file over to a file of records
 so it can be used with programs written by DESIGN.COM.
}
type
   string65 = string[65];
   recs = record
      line : string65;
   end;

const
   filenameout = 'HELP.TXT';

var
   diskfilein : text;
   rec : recs;
   diskfileout : file of recs;
   filenamein : string65;
   line : string65;

function Exist(Filename:string65):boolean;
VAR infile:text;

Begin                        { Find out if the file exists }
   Assign(Infile,Filename);
   {$I-}
   Reset(infile);
   {$I+}
   Exist := (IOresult = 0);
   close(infile)
end;

function uppercase(line:String65):String65;
var
   i : integer;
   ch : char;
   temp : string65;

begin
   temp := '';
   for i := 1 to length(line) do
   begin
      ch  := line[i];
      ch := upcase(ch);
      temp := concat(temp,ch);
   end;
   uppercase := temp
end;

begin { HelpConv }
   clrscr;
   gotoxy(20,10);
   write('Filename to convert --> ');
   readln(filenamein);
   if not exist(filenamein) then
   begin
      gotoxy(20,12);
      write('Filename ',filenamein,' not found.');
      halt
   end;
   filenamein := uppercase(filenamein);
      if filenamein = filenameout then
      begin
         gotoxy(20,12); clreol;
         write(#7,'Both filenames can''t have the same name.');
         halt
      end;
   assign(diskfilein,filenamein);
   reset(diskfilein);
   assign(diskfileout,filenameout);
   rewrite(diskfileout);
   while not eof(diskfilein) do
   begin
      readln(diskfilein,line);
      rec.line := line;
      write(diskfileout,rec)
   end;
   close(diskfilein);
   close(diskfileout);
   gotoxy(20,15);
   write(filenameout,' has been created.');
end.
