unit windows;
interface
uses dos,crt;

{$V-}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

type
   string10 = string[10];
   string80 = string[80];
   imagetype  = array [1..4096] of char;
     windimtype = record
                    x1,y1,x2,y2: integer
                  end;

const maxwin = 7;  { maximum number of windows open at once }


var
      a: integer;
  win: { Global variable package }
    record
      dim:    windimtype;  { Current window dimensions }
      depth:  integer;
      stack:  array[1..maxwin] of
                record
                  image: imagetype;  { Saved screen image }
                  dim:   windimtype; { Saved window dimensions }
                  x,y:   integer     { Saved cursor position }
                end
    end;

  crtmode:      byte      absolute $0040:$0049;
  crtwidth:     byte      absolute $0040:$004A;
  monobuffer:   imagetype absolute $B000:$0000;
  colorbuffer:  imagetype absolute $B800:$0000;

procedure fwrite(col,row,attrib:byte;str:string80);
procedure Init_Windows;
procedure Make_Window(x1,y1,x2,y2,t,b:integer);
procedure Remove_Window;
procedure Remove_Windows;
implementation
{ ----------------------------------------------------- }
procedure fwrite;
begin
inline
($1E/$1E/$8A/$86/row/$B3/$50/$F6/$E3/$2B/$DB/$8A/$9E/col/
 $03/$C3/$03/$C0/$8B/$F8/$be/$00/$00/$8A/$BE/attrib/
 $8a/$8e/str/$22/$c9/$74/$3e/$2b/$c0/$8E/$D8/$A0/$49/$04/
 $1F/$2C/$07/$74/$22/$BA/$00/$B8/$8E/$DA/$BA/$DA/$03/$46/
 $8a/$9A/str/$EC/$A8/$01/$75/$FB/$FA/$EC/$A8/$01/$74/$FB/
 $89/$1D/$47/$47/$E2/$Ea/$2A/$C0/$74/$10/$BA/$00/$B0/
 $8E/$DA/$46/$8a/$9A/str/$89/$1D/$47/$47/$E2/$F5/$1F);
end;
{ -------------------------------------------------------- }
{ Call Init_Windows before calling Make_Window or Remove_Window. }


procedure Init_Windows;
  { Records initial window dimensions }
begin
  with win.dim do
    begin x1:=1; y1:=1; x2:=crtwidth; y2:=25 end;
  win.depth:=0
end;

procedure boxwin(x1,y1,x2,y2,t,b:integer);
  { Draws a box, fills it with blanks, and makes it the current }
  { window.  Dimensions given are for the box; actual window is }
  { one unit smaller in each direction.                         }
  { This routine can be used separately from the rest of the    }
  { removable window package.                                   }
var x,y: integer;
begin
  textbackground(b);
  window(1,1,80,25);
  { Top }
  fwrite(x1-1,y1-1,b*16+t,#213);
  for x:=x1+1 to x2-1 do fwrite(x-1,y1-1,b*16+t,#205);
  fwrite(x2-1,y1-1,b*16+t,#184);

  { Sides }
  for y:=y1+1 to y2-1 do
   fwrite(x1-1,y-1,b*16+t,#179);
  for y:= y1+1 to y2-1 do
   fwrite(x2-1,y-1,b*16+t,#179);

  { Bottom }
  fwrite(x1-1,y2-1,b*16+t,#212);

  for x:=x1+1 to x2-1 do fwrite(x-1,y2-1,b*16+t,#205);
  fwrite(x2-1,y2-1,b*16+t,#190);

  { Make it the current window }
  window(x1+1,y1+1,x2-1,y2-1);
  clrscr;
  gotoxy(1,1)
end;

procedure Make_Window;
  { Create a removable window }

begin
  { Increment stack pointer }
  with win do depth:=depth+1;
  if win.depth>maxwin then
    begin
      writeln(' Window nesting error. ');
      exit
    end;

  { Save contents of screen }
  if crtmode = 7 then
    win.stack[win.depth].image := monobuffer
  else
    win.stack[win.depth].image := colorbuffer;

  win.stack[win.depth].dim := win.dim;
  win.stack[win.depth].x   := wherex;
  win.stack[win.depth].y   := wherey;

  { Create the window }
  boxwin(x1,y1,x2,y2,t,b);
  win.dim.x1 := x1+1;
  win.dim.y1 := y1+1;    { Allow for margins }
  win.dim.x2 := x2-1;
  win.dim.y2 := y2-1;

end;

procedure Remove_Window;
  { Remove the most recently created removable window }
  { Restore screen contents, window dimensions, and   }
  { position of cursor.  }
begin
  if win.depth < 1 then exit;
  if crtmode = 7 then
    monobuffer := win.stack[win.depth].image
  else
    colorbuffer := win.stack[win.depth].image;
  with win do
    begin
      dim := stack[depth].dim;
      window(dim.x1,dim.y1,dim.x2,dim.y2);
      gotoxy(stack[depth].x,stack[depth].y);
      depth := depth - 1
    end
end;

Procedure Remove_Windows;
Var
   i : integer;

begin
   for i := 1 to 5 do Remove_Window;
end;

end.
