unit datebox;
(*****************************
	Most parts of this unit were imported from Borland libraries
	(I'm R.Regez on GEnie and	100014,2516 on CompuServe) and adapted
	to my needs: 90/7.7.91.

	Many thanks to Gerald Rohr (GENIE G.ROHR), who writes in his TPWIO.PAS:
	  "Much credit is due Bill Meacham who wrote the original file IO22.INC
		and released it to the public domain.  Using that work this unit was
		created and added to by Gerald Rohr of Homogenized Software.  As
		with Bill's work, this program is released to the Public Domain for
		all to use and modify."

	Same to Rick Amerson (uploaded to GENIE by R.WERT) whose TURBO CALENDAR FUNCTIONS
	(Module version 1.01A; CALENDAR.PAS) inspired me to look around for the
	"ultimate date unit"!

   Last to join was Charles B. Chapman (CompuServe 74370,516, whose DAYFEASTER has
	been integrated, and whose Julian/Gregorian Routines seem to be the most
	sophisticated, at least, I understand them least...
	I have added JulianDay and JulianDaytoDate without integrating them.
	Should I use them?

	Using Rick Amerson's ideas, I added COUNTDAYS which extracts dates from
	INT's or LONGINT's which bear dates computed to a given baseyear (between
	1901-2100).	I needed that to access a broad Swiss stock market database
	where the dates	are "hidden" in INT's as differences to 1.1.1976 (without
	taking notice	of leapyears! The functions to correct that are part of a
	separate unit).	An illustration of this concept is in	FAR_DATE,
	which returns	the n-days in the future or in the past (-) lying date,
	relative to any date.

	A little bug in DAYOFWEEK (G.Rohr's ZELLER) has been corrected (?); the
	function returned some negative numbers in the years outside 1925-1999.
   An alternative by Charles B. Chapman has been added (as commentary), it
   seems to return identical values. And old Julius would rotate in his grave
	if he knew, that I'm calculating leapyears in "his" part of the calendar...

	Dear anglosaxons: Please don't use set types with text! If I try
	to adapt your programs to German or French, the chars above ASCII 127
	kill Turbo Pascal's compiler (syntax error 5)!
	Examples: your set type    monthname=(January,February,March...)
	translates to German as:  Monat_Name=(Januar,Februar,Mrz..) (ASCII 132)
				  to French as: nom_du_mois=(Janvier,Fvrier...)    (ASCII 130)
	You would not build set types with japanese chars, would you?

   Another problem is the format: Nobody here uses MM/DD/(CC)YY, just
   DD/MM/(CC)YY is common. Does "go metrics" in USA and UK solve this?
   At least, an USDATETEXT(), which calls DATETEXT() and cuts and pastes
   the resulting date-string, should be possible. Or should one try to
   link this format problem with the "language" switch?

	....and, dear anglosaxons: you might find my use of your language
	disturbing, please don't hesitate to inform me about the most terrible
	mistakes...
											Rudolf Regez, CH-8952 Schlieren,Switzerland.

*****************************)
INTERFACE
uses dos,crt,KEYBRD;
{ KEYBRD is my I/O-unit; just remove it's reference and the brackets
below, and keytype, keysettype and key will work standalone}
{
type
keytype =  (NullKey,CarriageReturn,TabKey,BackspaceKey,RightArrow,
				LeftArrow,DelKey,InsertKey,HomeKey,EndKey,TextKey,NumberKey,
				SpaceKey,EscapeKey);
keySetType = set of keyType;
var key:keytype;
}
var		baseyear:longint;				{range: 1901<=  baseyear  <=2100}
			language:integer;
			{0: english; german:1; french:2; italian:3}
			sysdatetime:datetime;  {Never use sysdatetime directly in procedures
         								or functions, it could get changed!}
			sysdate_str,sysdate10_str:string;
			separator:char;
			datekey:keytype;

FUNCTION	datetext(buf_dt:datetime;long:integer):string;
{  returns a string of the dates to print, returns different date formats
	dependent upon value of long and in the language set with the
	global variable "language" (default: German, of course, set in the
	initialization part of this unit)}
{	values of long:									 8 ->			02.09.91
															10 -> 		02.09.1991
	add 10 to eliminate leading zero's    18(20) ->			2.9.(19)91
	add 100 to get 'Mon, (D)D.(M)M.(YY)YY' format
	add 1000 to get 'Monday (D)D. September (YY)YY' format
	add 10000 to get 'Monday (D)D. Sep. (YY)YY' format								}

PROCEDURE read_date (var date_str:string;var dt:datetime;var key:keytype);
{reads date from keyboard after last cursor position and tests it
 if incoming date_str is not empty and if correct this serves als default}

FUNCTION check_date (var date_str:string):boolean;
{tests a string-date}

FUNCTION longdat_from_dt(newdt:datetime):longint;
{transforms datetime format into Longint CCYYMMDD ie 19911231}

PROCEDURE dt_from_longdat(newdt_long : longint;var new_dt:datetime);
{G. Rohr's get_dt_val; transforms Longint CCYYMMDD ie 19911231 into
 datetime format}

FUNCTION equal_date(dt1, dt2 : datetime) : boolean;         {Gerald Rohr}
{ Tests whether two dates are equal }

FUNCTION weekend(dt:datetime):boolean;                   	{Rudolf Regez}

PROCEDURE dt_from_stringdat(var s:string;var dt:datetime);	{Rudolf Regez}
{ converts date-string into datetime-date}

FUNCTION date_diff(dt1, dt2 : datetime) : longint;          {Gerald Rohr}
{ computes the number of days between two dates }

PROCEDURE next_day(var dt : datetime); 							{Gerald Rohr}
{ Adds one day to the date }

PROCEDURE next_workingday(var dt : datetime);               {Rudolf Regez}
{ Seeks next working day }

PROCEDURE prev_day(var dt : datetime); 							{Gerald Rohr}
{ Subtracts one day from the date }

PROCEDURE prev_workingday(var dt : datetime);               {Rudolf Regez}
{ Seeks prev working day }

FUNCTION far_date(var dt:datetime;d:longint):string;			{Rudolf Regez}
{..a more general next_/prev_day-routine}

PROCEDURE Today;  														{Rick Amerson}
{puts system date & time (time when unit is initialized) in the global
SYSDATETIME (DateTime) and returns the SYSDATE_STR-string}

FUNCTION countdays_into_dt (d:longint;var dt:datetime):string;      	{Rudolf Regez}
{converts d days from BASEYEAR, where: 1901<=BASEYEAR<=2100, in a
 DATE10_STR; valid date range: 1.1.0004<=DATE<=???? (at least 5101!)
 When DATE_DIFF is used to compute the days, add 1 day to include the starting
 point: d:=DATE_DIFF(baseyear_date,DATE)+1 to get the same date DATE back
 from DAYS_SINCE(d); BASEYEAR must be: 1.1.BASEYEAR,
 where: 1901<=BASEYEAR<=2100; example in FAR_DATE. I need that
 to read a compressed tw byte date from a large database which contains Swiss Stock Market prices}

FUNCTION count_days(dt:datetime):longint;							{Rudolf Regez}
{calculate number of days from 1.1.BASEYEAR; the result fed as "d" into
 COUNTDAYS_INTO_DT should return same dt}

FUNCTION count_intdays(dt:datetime):integer;							{Rudolf Regez}
{calculate INTEGER number of days from 1.1.BASEYEAR; the result fed as "d" into
 COUNTDAYS_INTO_DT should return same dt. LIMIT: 32767, of course! I need that
 to write a compressed tw byte date to a large database which contains
 Swiss Stock Market prices}

FUNCTION leapyear(yr:word):boolean;  								{Gerald Rohr}
{ Whether the year is a leap year or not.
  The year is year and century, e.g. year '1984' is 1984, not 84 }

PROCEDURE DateOfEaster (Yr : WORD; VAR Mo, Da : WORD);		{Charles B. Chapman}


IMPLEMENTATION
type
		juldate = record
			yr  : longint ; { 0 .. 9999 }
			day : longint ; { 1 .. 366 }
		end;
		str10=string[10];
		montharray = array [1 .. 13] of integer ;
		monthnamedef=array[1..48] of str10;
		daynamedef=array[0..27] of str10;

const
		dayname:daynamedef 	 	 =('Sunday','Monday','Tuesday','Wednesday',
											'Thursday','Friday','Saturday',
											'Sonntag','Montag','Dienstag','Mittwoch',
											'Donnerstag','Freitag','Samstag',
											'Dimanche','Lundi','Mardi','Mercredi',
											'Jeudi','Vendredi','Samedi',
											'Domenica','Lunedi','Martedi','Mercoledi',
											'Giovedi','Venerdi','Sabato');

		monthname:monthnamedef 	= ('January','February','March','April','May',
			'June','July','August','September','October','November','December',
											'Januar','Februar','Mrz','April','Mai',
			'Juni','Juli','August','September','Oktober','November','Dezember',
											'Janvier','Fvrier','Mars','Avril','Mai',
			'Juin','Juillet','Aot','Septembre','Octobre','Novembre','Dcembre',
											'Gennaio','Febbraio','Marzo','Aprile','Maggio',
			'Giugno','Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre');

		monthtotal : montharray 	=(0,31,59,90,120,151,181,212,243,273,304,334,365);
         { used to convert julian date to gregorian and back }

(*****************************)
PROCEDURE indatkey(var ch:char;var fk:boolean;var datekey:keytype);
{provides an enlarged READKEY-function, from source by S.K. O'Brien, Turbo
Pascal Advanced Programmer's Guide, Borland-Osborne/McGraw-Hill 1988,
shortened and isolated to avoid copyright troubles; it's a very useful
book to understand TP (5.5) fully!}
begin
ch:=readkey;
fk:=false;
if ch=#0 then begin
		fk:=true;
	  	ch:=readkey;
   end;

if fk then
   case ch of
      #82:datekey:=insertkey;
      #75:datekey:=leftarrow;
      #77:datekey:=rightarrow;
      #71:datekey:=homekey;
      #79:datekey:=endkey;
      #83:datekey:=delkey
   end
   else
   case ch of
	    #8:datekey:=backspacekey;
   	 #9:datekey:=tabkey;
     	#13:datekey:=carriagereturn;
     	#27:datekey:=escapekey;
		#32:datekey:=spacekey;
  	 	#33..#47,#58..#255: datekey:=textkey;
	   #48..#57: datekey:=numberkey;
   end;
end;
(*********************************)
FUNCTION check_date (var date_str:string):boolean;
{tests a string-date}
var		yr,mm,dd,daterror:integer;
			not_a_date:boolean;
	      buf_dt:datetime;
begin
	   not_a_date:=true;
		dt_from_stringdat(date_str,buf_dt);
      if pos('?',date_str)<>0 then not_a_date:=true
      else not_a_date:=false;

		if not not_a_date then begin
     {   check Year }
	   	val(copy(date_str,7,4),yr,daterror);
			if (yr<0) or (yr>9999) or (daterror<>0) then begin
				delete(date_str,7,4);
      		date_str:=concat(date_str,'????');
      	end;

     {   check Month }
			val(copy(date_str,4,2),mm,daterror);
	    	if (mm<1) or (mm>12) or (daterror<>0) then begin
				delete(date_str,4,2);
				insert('??',date_str,4);
      	end;

     {   check Day }
	    	not_a_date:=false;
			val(copy(date_str,1,2),dd,daterror);
	    	if (dd<1) or (dd>31) or (daterror<>0) then not_a_date:=true
      	else
		     case mm of
		       2: if dd>28 then
				        if dd>29 then not_a_date:=true
			        else
				        if not leapyear(yr) then not_a_date:=true;
		       4,6,9,11: if dd>30 then not_a_date:=true;
		     end;

      	if not_a_date then begin
				delete(date_str,1,2);
				insert('??',date_str,1)
      	end;
    	end;   {of if not not_a_date}

     if pos('?',date_str)<>0 then	begin
		 	check_date:=false;
     end
     else check_date:=true;
end;
(*********************************)
PROCEDURE read_date (var date_str:string;var dt:datetime;var key:keytype);
{reads date from keyboard after last cursor position and tests it
 if incoming date_str is not empty and if correct this serves als default}

var	strposx,homex,homey,bufbyte:byte;
		ch:char;
		fk:boolean;
		buf,buf1,sysdate_buf:string;
		daterror,dd,mm,yr,dayname:word;
begin
		str(sysdatetime.year,buf);                            {  Year }
		buf:='__'+separator+'__'+separator+copy(buf,1,2)+'__';

	if length(date_str)>0 then
	if  pos('_',date_str)=0 then
			if check_date(date_str) then buf:=date_str;
	if length(date_str)>10 then date_str:=copy(date_str,1,10);

	homex:=wherex+2;       { start 2 pos after last cursor position}
	homey:=wherey;
	strposx:=1;
	repeat
		gotoxy(homex,homey);
		write(buf);
      if pos('?',buf)<>0 then strposx:=pos('?',buf);
      while pos('?',buf)<>0 do buf[pos('?',buf)]:='_';
		gotoxy(homex+strposx-1,homey);
		indatkey(ch,fk,datekey);
    	if ch=separator then
			if (pos('_',buf)>0) and (strposx<>9)
				then datekey:=carriagereturn
         else datekey:=nullkey;

		case datekey of
         nullkey: {do nothing};
    		textkey:			write(#7);
		   numberkey:		begin
				if strposx=11 then strposx:=10;
				buf[strposx]:=ch;
				if pos('_',buf)>0 then strposx:=pos('_',buf)
				else if (strposx=2) or (strposx=5) then strposx:=strposx+2
					 else strposx:=strposx+1;
			end;
		   homekey: strposx:=1;
		   leftarrow: if strposx>1 then begin
				if (strposx=4) or (strposx=7) then strposx:=strposx-2
				else strposx:=strposx-1;
			end;
			rightarrow: if strposx<11 then begin
				if (strposx=2) or (strposx=5) then strposx:=strposx+2
				else strposx:=strposx+1;
			end;
		   delkey:  begin
	      	if (buf[strposx]='_') and (buf[strposx+1]<>separator) then
						buf[strposx+1]:='_'
          	else
						buf[strposx]:='_';
				end;
			backspacekey:	begin
				if strposx>1 then
					if (strposx=4) or (strposx=7) then begin
						strposx:=strposx-2;
						buf[strposx]:='_';
					end
					else begin
						strposx:=strposx-1;
						buf[strposx]:='_';
					end;
			end;
			carriagereturn:	begin
				if (pos('_',buf)<>0) then	begin
					datekey:=nullkey;
					case strposx of
						1: 	begin	if (buf[2]='_') and (buf[5]='_') then	begin
										buf:=datetext(sysdatetime,10);
										strposx:=11;
									end;
								end;
						2,5:begin	if (buf[strposx]='_') and
														(buf[strposx-1]<>'0') then
									begin
										buf[strposx]:=buf[strposx-1];
										buf[strposx-1]:='0';
									end;
								end;
						7,8: begin
										str(sysdatetime.year,buf1);
										delete(buf,7,4);
										buf:=concat(buf,buf1);
										strposx:=11;
								 end;
						9,10:begin
										str(sysdatetime.year,buf1);
										delete(buf,7,4);
										buf:=concat(buf,buf1);
					               if not check_date(buf) then begin
			           		      	strposx:=pos('?',buf);
         			             	write(#7);
                  			    	datekey:=nullkey;
					               end;
								end;
					end; {of case strposx of}
					strposx:=pos('_',buf);
				end	   {of if (pos('_',buf)<>0)...}
         	else
	         	if not check_date(buf) then begin
           			strposx:=pos('?',buf);
              		write(#7);
              		datekey:=nullkey;
	         	end;
			end;   {of case carriagereturn:}
		   else write(#7);
		end;     {of case datekey of}
		if strposx=0 then strposx:=11;

 	until datekey in [carriagereturn,escapekey];
	gotoxy(homex+11,homey);

  	if datekey=carriagereturn then begin
		with dt do begin
			    val(copy(buf,1,2),day,daterror);
			    val(copy(buf,4,2),month,daterror);
			    val(copy(buf,7,4),year,daterror);
	  	end;
		date_str:=buf;
   end
   else date_str:='??.??.????';
   key:=datekey;
end;
(*********************************)
FUNCTION leapyear(yr:word):boolean;  {Gerald Rohr}
{ Whether the year is a leap year or not.
  The year is year and century, e.g. year '1984' is 1984, not 84 }
begin
	 leapyear := ((yr mod 4 = 0) and (not(yr mod 100 = 0)))
						 or ( yr mod 400 = 0 )
end ;   {function leapyear}
(*******************************)
FUNCTION valid_date (var dt:datetime) : boolean ;		{Gerald Rohr}
{ Test whether date is valid }
var		bad_fld  :integer ;
begin
	with dt do begin
		bad_fld := 0 ;
		if (month = 0) and (day = 0) and (year = 0) then bad_fld := 0
		else
			if ((month <1) or (month>12)) then bad_fld := 1
			else
				if (day > 31) or (day < 1) or
					((month in [4,6,9,11]) and (day > 30)) then bad_fld := 2
			 	else	if month = 2 then begin
	    					if (leapyear(year) and (day > 29)) or
		   					((not leapyear(year)) and (day > 28)) then bad_fld := 2
					   end
						else if year = 0 then bad_fld := 3;
		valid_date := (bad_fld = 0);
      with dt do
			case bad_fld of
				0: ;
      	   1:	month:=0;
   	      2:	day:=0;
	      end;
	end;
end ; { function valid_date }
(*******************************)
PROCEDURE dt_from_stringdat(var s:string;var dt:datetime);		{Rudolf Regez}
{ converts date-string into datetime-date}
var
		stmo,stdy    :string[2];
		styr         :string[4];
		i,j  :integer ;
		found:boolean;
begin
		i:=1;
		found:=false;
		stmo:='';
		while (i<13) and (not found) do					{is it dd. monthname?}
			if (pos(monthname[i+language*12],s)<>0) then begin
				found:=true;
				str(i:1,stmo);
				if length(stmo) = 1 then stmo := concat('0',stmo);
				delete(s,pos(monthname[i+language*12],s),length(monthname[i+language*12]));
			end
			else	inc(i);
		while (length(s)>0) and not (s[1] in ['0'..'9']) do	{eliminate leading chars if any}
			delete(s,1,1);
		stdy:='';									{first number should be day}
		while (length(s)>0) and (s[1] in ['0'..'9']) do begin
				stdy:=concat(stdy,s[1]);
				delete(s,1,1);
		end;
		if length(stdy) = 1 then stdy := concat('0',stdy);
		delete(s,1,1);								{eliminate separator}

		while not ((s[1] in ['0'..'9']) or (length(s)=0)) do 		{clean string}
				delete(s,1,1);
		while not ((s[length(s)] in ['0'..'9']) or (length(s)=0)) do
				delete(s,length(s),1);

		if stmo='' then begin			{it is dd.mm}
			while (length(s)>0) and (s[1] in ['0'..'9']) do begin
					stmo:=concat(stmo,s[1]);
					delete(s,1,1);
			end;
			if length(stmo) = 1 then stmo := concat('0',stmo);
			delete(s,1,1);
		end;
		while not ((s[1] in ['0'..'9']) or (length(s)=0)) do 	{clean string}
			delete(s,1,1);
		styr:='';
		while (length(s)>0) and (s[1] in ['0'..'9']) do begin
				styr:=concat(styr,s[1]);
				delete(s,1,1);
		end;
		if length(styr) = 1 then styr := concat('0',styr);
		i:=0;
		with dt do begin
			val(styr,year,j);
			if j<>0 then styr:='????';
			val(stmo,month,j);
			if j<>0 then stmo:='??';
			val(stdy,day,j);
			if j<>0 then stdy:='??';
		end;
		if (not valid_date(dt)) then
         with dt do begin
         	if year=0 then styr:='????';
            if month=0 then stmo:='??';
            if day=0 then stdy:='??';
         end;
      s:=stdy+separator+stmo+separator+styr;
		if pos('?',s)=0 then	s:=stdy+separator+stmo+separator+styr
		else dt:=sysdatetime;
end ; { procedure dt_from_stringdat}
(*******************************)
FUNCTION equal_date(dt1, dt2 : datetime) : boolean;
{ Tests whether two dates are equal }
begin
	 equal_date := false;
	 if (dt1.year=dt2.year)	and (dt1.month=dt2.month) and (dt1.day=dt2.day)
	 then  equal_date := true;
end ;
(*******************************)
FUNCTION dayofweek(dt:datetime):integer;
{ Compute the day of the week using Zeller's Congruence.
From ROS 3.4 source code }  {Gerald Rohr}
var century,j: integer ;
begin
		if valid_date(dt) then
			with dt do begin
				if month > 2 then month := month - 2
				else begin
					month := month + 10 ;
					year := pred(year)
				end ;
				century := year div 100 ;
				year := year mod 100 ;
				j := (day - 1 + ((13 * month - 1) div 5) + (5 * year div 4) +
									century div 4 - 2 * century + 1) mod 7;

				if j<0 then dayofweek:=7-abs(j) else dayofweek:=j;
				{added by R.Regez to correct negative numbers occurring in years
				 outside 1925..1999}
			end
			else dayofweek:=-1;			{error indication}

(******* An alternative, which yields the same results, and seems to be
			closer to this Mr. Zeller...

  { Author: Charles B. Chapman, London, Ontario, Canada CompuServe  [74370,516]}

  FUNCTION DayOfYear (y, m, d : WORD) : WORD;

  { function IDAY from remark on CACM Algorithm 398                        }
  { Computes day of the year for a given calendar date                     }
  { GIVEN:   y - year                                                      }
  {          m - month                                                     }
  {          d - day                                                       }
  { RETURNS: day-of-the-year (1..366, given valid input)                   }

  VAR
    yy, mm, dd, Tmp1 : LONGINT;
  BEGIN
    yy := y;
    mm := m;
    dd := d;
    Tmp1 := (mm + 10) DIV 13;
    DayOfYear :=  3055 * (mm + 2) DIV 100 - Tmp1 * 2 - 91 +
                  (1 - (yy - yy DIV 4 * 4 + 3) DIV 4 +
                  (yy - yy DIV 100 * 100 + 99) DIV 100 -
                  (yy - yy DIV 400 * 400 + 399) DIV 400) * Tmp1 + dd
  END;  { DayOfYear }
        								***********)
end ;  { function dayofweek }
(*******************************)
FUNCTION weekend(dt:datetime):boolean;
var j:integer;
begin
	j:=dayofweek(dt);
	if j>=0 then
		if j in [1..5] then weekend:=false else weekend:=true;
end;
(*******************************)
PROCEDURE greg_to_jul(dt : datetime ; var jdt : juldate);   {Gerald Rohr}
{ converts a tested gregorian date to a julian date }
begin
	 with dt do begin
		 jdt.yr := year ;
		 if (year = 0) and (month = 0) and (day = 0) then
				jdt.day := 0
		 else
			begin	if (leapyear(year)) and (month > 2) then jdt.day := 1
					else jdt.day := 0 ;
				jdt.day := jdt.day + monthtotal[month] + day;
		 	end;
	 end;
end ;  { --- procedure greg_to_jul --- }
(*****************************)
PROCEDURE jul_to_greg(jdt : juldate ; var dt : datetime);   {Gerald Rohr}
{ converts a tested julian date to a gregorian date }
var
   i, workday :integer ;
begin
	with dt do begin
		year := jdt.yr ;
      if (jdt.yr = 0) and (jdt.day = 0) then begin
	      month := 0 ;
	      day := 0;
      end
      else begin
         workday := jdt.day ;
         if (leapyear(jdt.yr)) and (workday > 59) then
            workday := workday - 1 ;   { make it look like a non-leap year }
         i := 1 ;
         repeat
            i := i + 1
         until not (workday > monthtotal[i]);
         i := i - 1 ;
		      month := i ;
		      day := workday - monthtotal[i] ;
         if leapyear(jdt.yr) and (jdt.day = 60) then
			       day := day + 1
      end;
	end;
end ;  { --- procedure jul_to_greg --- }
(*****************************)
FUNCTION date_diff(dt1, dt2 : datetime) : longint;          {Gerald Rohr}
{ computes the number of days between two dates }
var
	jdt1, jdt2 : juldate ;
	i,num_leap_yrs:integer;
begin
	if valid_date(dt1) and valid_date(dt2) then begin
		greg_to_jul (dt1, jdt1);
		greg_to_jul (dt2, jdt2);
		num_leap_yrs := 0 ;         { adjust for leap years }
		if dt2.year > dt1.year then
			for i := dt1.year to dt2.year - 1 do
				if leapyear(i) then	num_leap_yrs := num_leap_yrs + 1
		else
			if dt1.year > dt2.year then
				for i := dt2.year to dt1.year - 1 do
					if leapyear(i) then num_leap_yrs := num_leap_yrs - 1;

		date_diff := jdt2.day - jdt1.day +
									((jdt2.yr - jdt1.yr) * 365) + num_leap_yrs;
	 end
	 else date_diff:=-99999999;		{something's wrong}
end ;
(*******************************)
PROCEDURE next_day(var dt : datetime); {Gerald Rohr}
{ Adds one day to the date }
var
   jdt  : juldate ;
   leap : boolean ;
begin
	if valid_date(dt) then begin
		greg_to_jul (dt,jdt);
		jdt.day := jdt.day + 1 ;
		leap := leapyear (dt.year);
		if (leap and (jdt.day = 367)) or (not leap and (jdt.day = 366)) then
		begin
			jdt.yr := jdt.yr + 1 ;
			jdt.day := 1
		end;
		jul_to_greg (jdt,dt);
	 end
	 else fillchar(dt,sizeof(dt),'9');
end ;  { --- procedure next_day --- }
(*******************************)
PROCEDURE next_workingday(var dt : datetime);
{ Seeks next working day }
begin
		next_day(dt);
		while weekend(dt) do next_day(dt);
end;
(*******************************)
PROCEDURE prev_day(var dt : datetime); {Gerald Rohr}
{ Subtracts one day from the date }
var	jdt : juldate ;
begin
		if valid_date(dt) then begin
			greg_to_jul (dt,jdt);
			jdt.day := jdt.day - 1 ;
			if jdt.day < 1 then begin
				 jdt.yr := jdt.yr - 1 ;
				 if leapyear (jdt.yr) then	jdt.day := 366
				 else	jdt.day := 365
			end;
			jul_to_greg (jdt,dt);
	 	end
	 	else fillchar(dt,sizeof(dt),'9');
end ;  { --- procedure prev_day --- }
(*******************************)
PROCEDURE prev_workingday(var dt : datetime);
{ Seeks prev working day }
begin
		prev_day(dt);
		while weekend(dt) do prev_day(dt);
end;
(*******************************)
FUNCTION longdat_from_dt(newdt:datetime):longint;
{transforms datetime format into Longint CCYYMMDD ie 19911231}
var		buf_dtnum:longint;
begin
	with newdt do begin
		buf_dtnum := year;
		buf_dtnum := (buf_dtnum * 100) + month;
		buf_dtnum := (buf_dtnum * 100) + day;
	end;
	longdat_from_dt:=buf_dtnum;
end;
(********************************)
PROCEDURE dt_from_longdat(newdt_long:longint;var new_dt:datetime);
{G. Rohr's get_dt_val; transforms Longint CCYYMMDD ie 19911231
				into datetime format}
var 	result:longint;
begin
	with new_dt do begin
		day := (newdt_long mod 100);
   	result := newdt_long div 100;  	{ move to right }
	 	month := (result mod 100); 		{ get the month }
	 	year := (result div 100); 			{ get year }
	end;
end;
(********************************)
FUNCTION	datetext(buf_dt:datetime;long:integer):string;
{ returns a string of the dates to print, returns different date formats
	dependent upon value of long in english or german}
{	values of long:							 8 ->	 			02.06.91
													10 -> 			02.06.1991
	add 10 to eliminate leading zero's  18(20) ->		2.6.(19)91
	add 100 to get 'Mon, (D)D.(M)M.(YY)YY' format
	add 1000 to get 'Monday (D)D. June (YY)YY' format						}
var		stmo,stdy   :string[2];
			styr        :string[4];
			buf,buf1		:string;
         buf_ch		:string[1];
			newdt_long	:longint;
			textlong,i,j	:integer;
begin
	if valid_date(buf_dt) then begin
		newdt_long:=longdat_from_dt(buf_dt);
		with buf_dt do begin
			str(year:1,styr);
        	if newdt_long>999999 then		{Century is there}
				while length(styr)<4 do styr := concat('0',styr)
        	else										{Century is not there}
				if (long mod 5)=0 then
					while length(styr)<2 do styr := concat('0',styr)
         	else
					while length(styr)<4 do styr := concat('0',styr);

			str(month:1,stmo);
			if length(stmo) = 1 then stmo := concat('0',stmo);
			str(day:1,stdy);
			if length(stdy) = 1 then stdy := concat('0',stdy);
			buf := concat(stdy,separator,stmo,separator,styr);
		end;

		long:=abs(long);									{some testing, incomplete}
		str(long,buf1);
		if not (buf1[length(buf1)] in ['0','8']) then long:=10;
		if long>11200 then long:=10;

		textlong:=long;									{save incoming value}
		if long mod 5=0 then long:=long-10			{it's 4-digit year}
		else begin
			buf:=copy(buf,1,6)+copy(buf,9,2);  		{it's 2-digit year}
			long:=long-8;
		end;

{		add 10 to eliminate leading zero's   8(10) ->			2.6.(19)91	}
		if (not (long mod 100=0) and (long mod 10=0)) then begin
			if buf[4]='0' then delete(buf,4,1);		{eliminate leading zero's}
			if buf[1]='0' then delete(buf,1,1);
			long:=long-10;
		end;

{		add 100 to get 'Mon, (D)D.(M)M.(YY)YY' format}
{		add 1000 to get 'Monday (D)D. June (YY)YY' format}
{		add 10000 to get 'Monday (D)D. Jun. (YY)YY' format}

		if long>99 then begin								{Day or month as text?}
			j:=dayofweek(buf_dt);
			if long=1000 then begin
				if newdt_long>999999 then		{Century is there}
					insert(dayname[j+language*7]+', ',buf,1)		{full day name}
          	else	insert('???'+', ',buf,1);
			end
			else
	      	if newdt_long>999999 then		{Century is there}
					insert(copy(dayname[j+language*7],1,3)+', ',buf,1)	{3-digit day name}
	         else	insert('???'+', ',buf,1);

			if long>999 then begin																{month name?}
				if textlong mod 5<>0 then delete(styr,1,2);  	{2 digit year?}
				if long>9999 then 																{month name?}
					if length(monthname[buf_dt.month+language*12])>4 then
						buf1:=copy(monthname[buf_dt.month+language*12],1,3)+'.'
					else
						buf1:=monthname[buf_dt.month+language*12]
				else
					buf1:=monthname[buf_dt.month+language*12];

            i:=length(buf)-1;
            while not (buf[i]=separator) do dec(i);
            j:=i-1;
            while not (buf[j]=separator) do dec(j);
				delete(buf,j,i-j+1);
				insert('. '+buf1+' ',buf,j);
			end;
		end;
		datetext:=buf;
	end
   else datetext:='??.??.????';
end;
(********************************)
PROCEDURE Today;  {Rick Amerson}
			{puts system date & time (time when unit is initialized)
			 in the global SYSDATETIME (DateTime) and returns
			 the "sysdate_str" and "sysdate10_str"-strings}
var		wtag,sec100:word;
begin
	      with sysdatetime do begin
		      getdate(year,month,day,wtag);
		      gettime(hour,min,sec,sec100);
	      end;
         sysdate_str:=datetext(sysdatetime,10+10+100);
         sysdate10_str:=datetext(sysdatetime,10);
end; {Today}
(*****************************)
FUNCTION countdays_into_dt(d:longint;var dt:datetime):string;    {Rudolf Regez}

{converts d days from BASEYEAR, where: 1901<=BASEYEAR<=2100, in a
 DATE10_STR; valid date range: 1.1.0004<=DATE<=???? (at least 5101!)
 When DATE_DIFF is used to compute the days, add 1 day to include the starting
 point: d:=DATE_DIFF(baseyear_date,DATE)+1 in order to get the same date
 DATE back from DAYS_SINCE(d); BASEYEAR must be: 1.1.BASEYEAR,
 where: 1901<=BASEYEAR<=2100; example in FAR_DATE below}

var 	buf_baseyear,buf_d,x,y,z,i,j,jahr:longint;
		julia:juldate;
begin
		if (baseyear<1901) or (baseyear>2100) then baseyear:=1901;
		{chose between:  1901<=baseyear<=2100!}
		buf_baseyear:=baseyear;
		buf_d:=d;

		if d<=0 then begin
			if d mod 1461=0 then buf_baseyear:=buf_baseyear-(abs(d) div 1461)*4
			else	buf_baseyear:=buf_baseyear-(abs(d) div 1461+1)*4;
												{move baseyear by whole leap-periods}
			if d mod 1461=0 then d:=0
			else d:=d+(abs(d) div 1461+1)*1461;
			buf_d:=d;
		end;
		if buf_baseyear>=0 then begin
			z:=buf_baseyear mod 4;
			if z=0 then z:=4;		{leapyear}
			d:=d+(z-1)*365;			{standardize to year following a leapyear}
			x:=d div 1461;			{past whole leap-periods}
			jahr:=buf_baseyear+(buf_d-x) div 365;			{ca year}
			d:=d-(x*1461);			{days in last (broken) period}
			if ((buf_d-x) mod 365=0) then begin
				dec(jahr);
				if d=0 then begin
					if (jahr>=2100) then begin
						inc(jahr);
					end
					else
					if leapyear(jahr) then d:=366 else d:=365;
				end
				else d:=365;   {31.12.xxxx}
			end
			else d:=buf_d-(jahr-buf_baseyear)*365-x;				{days}

			y:=(1900 div 100)-((buf_baseyear-1) div 100);    {correct dates before
											 1900 for non-leapyears 1900,1800,1700...}
			i:=(buf_baseyear+4)-100*(buf_baseyear div 100);
			if z<>4 then i:=i-100;
			if z=i  then begin
				if z=2 then
					if (buf_d>1095) then dec(y);
				if z=3 then
					if (buf_d>730) then	dec(y);
				if (z=4) then
					if (buf_d>365) then	dec(y);
			end;

			y:=y-(y div 4);
			if y<0 then y:=0;
			for i:=1 to y do begin
				dec(d);
				if d=0 then begin
					dec(jahr);
					if leapyear(jahr) then d:=366 else d:=365;
				end;
			end;

			y:=((jahr-1) div 100)-(1900 div 100)-1;					{correct dates beyond
											 2100 for non-leapyears 2200,2300,2500...}
			y:=y-(y div 4);
			if y<0 then y:=0;
			for i:=1 to y do begin
				if (d<365) then inc(d)
				else
					if leapyear(jahr) then begin
						if d=366 then begin
							inc(jahr);
							d:=1;
						end
						else inc(d);
					end
					else
						if d=365 then begin
							inc(jahr);
							d:=1;
						end;
				end;

			with julia do begin
				yr:=jahr;
				day:=d;
			end;
			fillchar(dt,sizeof(dt),0);
			jul_to_greg(julia,dt);					{build datetime-date}
			countdays_into_dt:=datetext(dt,10);
															{build DD.MM.YYYY-string}
		end
		else countdays_into_dt:='??.??.????';		{buf_baseyear<0 =>got bombed!}
end; 	{function days_since}
(*******************************)
FUNCTION count_days(dt:datetime):longint;							{Rudolf Regez}
{calculate number of days from 1.1.BASEYEAR; the result fed as "d" into
 COUNTDAYS_INTO_DT should return same dt}
var 	base_dt:datetime;
begin
	if valid_date(dt) then begin
		with base_dt do begin
			year:=baseyear;
			month:=1;
			day:=1;
		end;
		count_days:=date_diff(base_dt,dt)+1;	{add 1 day, it's number of the }
	end													{days not the difference!}
   else count_days:=999999;
end;
(*******************************)
FUNCTION count_intdays(dt:datetime):integer;							{Rudolf Regez}
{calculate INTEGER number of days from 1.1.BASEYEAR; the result fed as "d" into
 COUNTDAYS_INTO_DT should return same dt. LIMIT: 32767, of course! I need that
 to write a compressed tw byte date to a large database which contains
 Swiss Stock Market prices}
var	buf_d:longint;
begin
	buf_d:=count_days(dt);
   if abs(buf_d)<maxint then count_intdays:=integer(buf_d)
	else count_intdays:=0;
end;
(*******************************)
FUNCTION far_date(var dt:datetime;d:longint):string;			{Rudolf Regez}
{..a more general next_/prev_day-routine}
var base_dt:datetime;
		buf_d:longint;
		buf:string;
begin
      buf_d:=count_days(dt);
      if buf_d<>999999 then begin
			buf_d:=buf_d+d;
			buf:=countdays_into_dt(buf_d,dt);
			far_date:=buf;
		end
		else far_date:='??.??.????';
end;
(*******************************)
  PROCEDURE DateOfEaster (Yr : WORD; VAR Mo, Da : WORD);
  { Author: Charles B. Chapman, London, Ontario, Canada [74370,516]        }
  { Thanks to Leonard Erickson who supplied a test suite of values.        }

  { Algorithm "E" from Knuth's "Art of Computer Programming", vol. 1       }
  { Computes date of Easter for any year in the Gregorian calendar         }
  { The local variables are the variable names used by Knuth.              }
  { GIVEN:   Yr - year                                                     }
  { RETURNS: Mo - month of Easter (3 or 4)                                 }
  {          Da - day of Easter                                            }

  VAR
    G, C, X, Z, D, E, N : LONGINT;
  BEGIN
  { Golden number of the year in Metonic cycle   }
    G := Yr MOD 19 + 1;
  { Century  }
    C := Yr DIV 100 + 1;
  { Corrections: }
  { <X> is the no. of years in which leap-year was dropped in }
  { order to keep step with the sun   }
  { <Z> is a special correction to synchronize Easter with the }
  { moon's orbit  . }
    X := (3 * C) DIV 4 - 12;
    Z := (8 * C + 5) DIV 25 - 5;
  { <D> Find Sunday   }
    D := (5 * Yr) DIV 4 - X - 10;
  { Set Epact  }
    E := (11 * G + 20 + Z - X) MOD 30;
    IF E < 0 THEN
      E := E + 30;
    IF ((E = 25) AND (G > 11)) OR (E = 24) THEN
      E := E + 1;
  { Find full moon - the Nth of MARCH is a "calendar" full moon }
    N := 44 - E;
    IF N < 21 THEN
      N := N + 30;
  { Advance to Sunday }
    N := N + 7 - ((D + N) MOD 7);
  { Get Month and Day }
    IF N > 31 THEN
      BEGIN
        Mo := 4;
        Da := N - 31
      END
    ELSE
      BEGIN
        Mo := 3;
        Da := N
      END
  END; { DateOfEaster }
(*******************************)
  FUNCTION JulianDay (y, m, d : WORD) : LONGINT;			{Charles B. Chapman}

  { procedure JDAY from CACM Alorithm 199                                  }
  { Computes Julian day number for any Gregorian Calendar date             }
  { GIVEN:   y - year                                                      }
  {          m - month                                                     }
  {          d - day                                                       }
  { RETURNS: Julian day number (astronomically, for the day                }
  {          beginning at noon) on the given date.                         }

  VAR
    Tmp1, Tmp2, Tmp3, Tmp4, Tmp5 : LONGINT;
  BEGIN
    IF m > 2 THEN
      BEGIN
        Tmp1 := m - 3;
        Tmp2 := y
      END
    ELSE
      BEGIN
        Tmp1 := m + 9;
        Tmp2 := y - 1
      END;
    Tmp3 := Tmp2 DIV 100;
    Tmp4 := Tmp2 MOD 100;
    Tmp5 := d;
    JulianDay := (146097 * Tmp3) DIV 4 + (1461 * Tmp4) DIV 4 +
                 (153 * Tmp1 + 2) DIV 5 + Tmp5 + 1721119
  END;  { JulianDay }
(*******************************)
PROCEDURE JulianDayToDate (nd : LONGINT; VAR y, m, d : WORD);{Charles B. Chapman}

  { procedure JDATE from CACM Algorithm 199                                }
  { Computes calendar date from a given Julian day number for any          }
  { valid Gregorian calendar date                                          }
  { GIVEN:   nd - Julian day number (2440000 --> 1968 5 23)                }
  { RETURNS: y - year                                                      }
  {          m - month                                                     }
  {          d - day                                                       }

  VAR
    Tmp1, Tmp2, Tmp3 : LONGINT;
  BEGIN
    Tmp1 := nd - 1721119;
    Tmp3 := (4 * Tmp1 - 1) DIV 146097;
    Tmp1 := (4 * Tmp1 - 1) MOD 146097;
    Tmp2 := Tmp1 DIV 4;
    Tmp1 := (4 * Tmp2 + 3) DIV 1461;
    Tmp2 := (4 * Tmp2 + 3) MOD 1461;
    Tmp2 := (Tmp2 + 4) DIV 4;
    m := ((5 * Tmp2 - 3) DIV 153);
    Tmp2 := (5 * Tmp2 - 3) MOD 153;
    d := ((Tmp2 + 5) DIV 5);
    y := (100 * Tmp3 + Tmp1);
    IF m < 10 THEN
      m := m + 3
    ELSE
      BEGIN
        m := m - 9;
        y := y + 1
      END
  END;  { JulianDayToDate }
(*******************************)
begin
separator:='.';				{all sorts of separators possible}
language:=1;					{0: english; german:1; french:2; italian:3}
baseyear:=1976;				{be careful setting this one! The baseyear should be
									 constant within your applications! (set baseyear to
									 2099 and try to read INT-dates from a file which were
									 calculated to the base 1976!}

today;
end.