(**************************************************)
(*                                                *)
(*   Sample3D - Shows the use of CTL3D.DLL        *)
(*                                                *)
(*   Supplied by Andreas Furrer                   *)
(*                                                *)
(**************************************************)

program Sample3D;

{$R sample3d.res}


uses WinTypes, WinProcs, WObjects, CommDlg, Ctl3d;

type
   Applikation =
      object(TApplication)
         procedure InitMainWindow; virtual;
      end;

   PMainwindow = ^TMainwindow;
   TMainwindow =
      object(TDialog)
         procedure WMDlgBorder(var Msg : TMessage); virtual wm_DlgBorder;
         procedure WMDlgSubclass(var Msg : TMessage); virtual wm_DlgSubclass;
         procedure WMSysColorChange(var Msg : TMessage); virtual wm_first + wm_SysColorChange;
         procedure Msgbox(var Msg : TMessage);   virtual id_first + 130;
         procedure Fileopen(var Msg : TMessage); virtual id_first + 131;
      end;



procedure TMainwindow.WMDlgBorder;
begin
{ Remove the comments from the next block of code to      }
{ stop the dialog border form being drawn with 3D effects }
{
  PInteger(Msg.lParam)^ := Ctl3d_NoBorder;
}
end;

procedure TMainwindow.WMDlgSubclass;
begin
{ Remove the comments from the next block of code to      }
{ stop subclassing the controls on this dialog            }
{
  PInteger(Msg.lParam)^ := Ctl3d_NoSubclass;
}
end;

procedure TMainwindow.WMSysColorChange;
begin
  Ctl3dColorChange;
end;

procedure TMainwindow.Msgbox;
begin
  MessageBox(HWindow,'This is a sample Message Box','3D Look',mb_Ok);
end;


function HookProc(HWindow: HWnd; Msg, wParam: word; lParam: longint): word;far;
var p : TFarProc;
begin
  IF Msg=wm_InitDialog then begin
    Ctl3dSubClassDlg(HWindow,Ctl3d_All);
  end;
  HookProc:=0;
end;

procedure TMainwindow.Fileopen;
var FileName : array[0..255] of char;
    Ofn :  TOpenFileName;
begin
  FileName[0]:=#0;
  Ofn.lStructSize       := sizeof(TOpenFileName);
  Ofn.hwndOwner         := HWindow;
  Ofn.hInstance         := HInstance;
  Ofn.lpstrFilter       :='Text Files (*.TXT)'+#0+'*.TXT'+#0+'All Files (*.*)'+#0+'*.*'+#0+#0;
  Ofn.lpstrCustomFilter := nil;
  Ofn.nMaxCustFilter    := 0;
  Ofn.nFilterIndex      := 1;
  Ofn.lpstrFile         := FileName;
  Ofn.nMaxFile          := sizeof(FileName);
  Ofn.lpstrFileTitle    := nil;
  Ofn.nMaxFileTitle     := 0;
  Ofn.lpstrInitialDir   := nil;
  Ofn.lpstrTitle        := '3D Look';
  Ofn.Flags             := ofn_HideReadonly or ofn_EnableHook;
  Ofn.nFileOffset       := 0;
  Ofn.nFileExtension    := 0;
  Ofn.lpstrDefExt       := NIL;
  Ofn.lpTemplateName    := 'FileOpen';
  Ofn.lCustData         := 0;
  Ofn.lpfnHook         := HookProc;
  GetOpenFileName(Ofn);
end;

procedure Applikation.InitMainWindow;
begin
  MainWindow := New(PMainwindow, Init(nil, MakeIntResource(100)));
end;

var Prg : Applikation;

begin
   Ctl3dRegister(HInstance);
   Ctl3dAutoSubclass(HInstance);

   Prg.Init('Sample3D');
   Prg.Run;
   Prg.Done;

   Ctl3dUnregister(HInstance);
end.