{$N+,E+}
{video routines for contour plots
 copyright 1988, Optimal Systems Laboratory, Plainfield, NJ}
unit Video;

interface

uses graph, c_defs;

{procedure init_graphics;
  initializes crt to graphics mode
 }
procedure init_graphics;

{procedure close_graphics;
  restores crt to text mode
 }
procedure close_graphics;

{procedure make_line(block_x, block_y : integer
  ;local_x_start, local_y_start, local_x_finish, local_y_finish : float
  ;c_number,x_size,y_size :integer) ;

 plots a single line in a single bilinear patch

 inputs:
  block_x,block_y     x,y numbers of this patch

  local_x_start,      x,y coordinates of start point relative to this patch
  local_y_start

  local_x_stop,     x,y coordinates of stop point relative to this patch
  local_y_stop

  c_number          number of contour for plotting, used to set color
                    of line

  x_size,y_size     size of original data array (for scaling)

 }
procedure make_line(block_x, block_y : integer
  ;local_x_start, local_y_start, local_x_finish, local_y_finish : float
  ;c_number,x_size,y_size :integer) ;

implementation

procedure init_graphics;
  var
    graph_driver, graph_mode, error_code : integer;

  begin
    graph_driver:=detect;
    initgraph(graph_driver,graph_mode,'');
    error_code:=graphresult;
    if (error_code<>grOK) then
      begin
        writeln('Graphics error=',grapherrormsg(error_code));
        halt(1);
      end;
  end;

procedure make_line(block_x, block_y : integer
  ;local_x_start, local_y_start, local_x_finish, local_y_finish : float
  ;c_number,x_size,y_size :integer) ;

  var
    x_start, y_start, x_finish, y_finish, color : integer;

  begin
    color:=(c_number mod getmaxcolor)+1;
    setcolor(color);
    x_start:=round(getmaxx*(block_x+local_x_start)/(x_size-1));
    y_start:=round(getmaxy*(block_y+local_y_start)/(y_size-1));
    x_finish:=round(getmaxx*(block_x+local_x_finish)/(x_size-1));
    y_finish:=round(getmaxy*(block_y+local_y_finish)/(y_size-1));
    line(x_start,y_start,x_finish,y_finish);
  end;

procedure close_graphics ;

  begin
    closegraph;
  end;

end.
