;===========================================================================
;
;    S T R P L A T E   --  Boilerplate string external function
;
;===========================================================================
;
;     by Jeff Duntemann      19 February 1988
;
;     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann
;    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5
;
; STRPLATE is written to be called from Turbo Pascal V4.0 using the
; EXTERNAL procedure convention.
;
; Declare the procedure itself as external using this declaration:
;
; {$L STRPLATE}
; FUNCTION STRPLATE(Source : String) : String;
;                                     EXTERNAL;
;
; This function doesn't do anything useful; it simply copies the value of
; Source into the function result.
;
; To reassemble/relink STRPLATE:
;-------------------------------------
; Assemble this file with MASM.  "C>MASM STRPLATE;"
;
; The following value can be set to anything between 1 and 255.  80 and 255
; are the commonest and most useful values.  It represents the physical
; length of the string, and MUST match the length of the return string value
; as declared in the Pascal program for the external function.

PHYSLEN   EQU  255

;
; This structure defines the layout of parameters on the stack.  There is
; only one parameter, a string value.  Other parameters would replace the
; PARMPTR field or be added adjacent to it.  Keep in mind that parms
; declared in the function header AFTER the string parm would be added to
; ONSTACK in the position ABOVE the PARMPTR field!
;

ONSTACK   STRUC
OLDBP     DW   ?               ;CALLER'S BP VALUE
RETADDR   DW   ?               ;RETURN ADDRESS

PARMPTR   DD   ?               ;POINTER TO THE STRING PARAMETER

FUNCPTR   DD   ?               ;POINTER TO FUNCTION RESULT WORK AREA
ONSTACK   ENDS


CODE      SEGMENT BYTE PUBLIC
          ASSUME  CS:CODE
          PUBLIC  STRPLATE

STRPLATE  PROC    NEAR         ;MAKE IT A FAR PROC IF IT'S IN A UNIT!
          PUSH    BP           ;SAVE PREVIOUS VALUE OF BP ON STACK
          MOV     BP,SP        ;SP BECOMES NEW VALUE OF BP


; The "meat" of your own string function should go between the dashed lines.
; leave the stuff outside the dashed lines, alone, unless you change the
; parameter structure or the physical length of the string passed and
; returned.  An assumption made here is that the physical length of the
; string parameter is the same as the physical length of the return value.
; You can easily violate this assumption...but I would advise against it.
;--------------------------------------------------------------------------

; For an example operation, let's copy the parm into the function result:

          PUSH    DS              ;SAVE CALLER'S DS
          LDS     SI,[BP].PARMPTR ;MOVE PARAMETER ADDRESS INTO DS:SI
          LES     DI,[BP].FUNCPTR ;MOVE FUNCTION RESULT ADDRESS INTO ES:DI
          MOV     CX,PHYSLEN+1    ;NUMBER OF BYTES TO MOVE
          CLD                     ;SET DIRECTION FLAG FOR AUTO INCREMENT
          REPZ MOVSB              ;PERFORM THE BLOCK MOVE

;--------------------------------------------------------------------------

          POP     DS              ;RESTORE CALLER'S DS VALUE
          MOV     SP,BP           ;RESTORE CALLER'S STACK POINTER
          POP     BP              ;RESTORE CALLER'S BASE POINTER
          RET     FUNCPTR-RETADDR-2   ;CLEAN UP STACK AND RETURN

STRPLATE  ENDP
CODE      ENDS
          END
