{->>>>ShowHelp<<<<---------------------------------------------}
{                                                              }
{ Filename : SHOWHELP.SRC -- Last Modified 7/14/88             }
{                                                              }
{ This is a simple, single-screen help system that will save   }
{ the underlying screen, show a single screen's worth of help  }
{ information, and then restore the underlying screen once any }
{ key is pressed.  You must customize the ShowHelpData routine }
{ with your own help information; the data shown here is for   }
{ the JTERM terminal program from Section 23.7.                }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE ShowHelp;    { Shows a help screen display on press of F1 }

CONST
  ScreenX = 80;
  ScreenY = 25;   { This could be 43 for the EGA; 50 for VGA; 66 for Genius }

VAR
  XSave,YSave : Integer;
  VidSegment : Word;
  VideoBufferSize : Word;
  SavePtr  : ^Word;
  VideoPtr : ^Word;
  VideoSeg : Word;
  Dummy    : Char;


FUNCTION Monochrome : Boolean;

VAR
  Regs : Registers;

BEGIN
  INTR(17,Regs);
  IF (Regs.AX AND $0030) = $30 THEN Monochrome := True
    ELSE Monochrome := False
END;


PROCEDURE SaveScreenOut;

BEGIN
  XSave := WhereX; YSave := WhereY;       { Save the underlying cursor pos. }
  VideoBufferSize := ScreenX*ScreenY*2;   { E.g., 25 X 80 X 2 = 4000 bytes  }
  { Allocate memory for stored screen: }
  GetMem(SavePtr,VideoBufferSize);
  IF Monochrome THEN VidSegment := $B000 ELSE  { Get a screen buffer origin }
    VidSegment := $B800;
  VideoPtr := Ptr(VidSegment,0);          { Create a pointer to the buffer  }
  Move(VideoPtr^,SavePtr^,VideoBufferSize);  { Save screen out to the heap  }
END;


PROCEDURE ShowHelpData;

BEGIN
  GotoXY(30,3); Writeln('>>>JTERM<<<');
  Write('          From COMPLETE TURBO PASCAL 5.0, by Jeff Duntemann');
  GotoXY(1,7);
  Writeln('The default communications parameters are 1200, 8, N, 1');
  Writeln('You can use JTERM at 300 baud by invoking it this way:');
  Writeln;
  Writeln('  C:\>JTERM 300');
  Writeln;
  Writeln('Currently active commands are:');
  Writeln;
  Writeln('  F1:     Displays this help screen');
  Writeln('  Ctrl-Z: Clears the screen');
  Writeln('  Ctrl-X: Hangs up and exits JTERM');
END;


PROCEDURE BringScreenBack;

BEGIN
  Move(SavePtr^,VideoPtr^,VideoBufferSize);  { Bring screen back from heap  }
  FreeMem(SavePtr,VideoBufferSize);          { Free up the meap memory      }
  GotoXY(XSave,YSave);                   { Put the cursor back where it was }
END;


BEGIN  { ShowHelp }
  SaveScreenOut;
  ClrScr;
  ShowHelpData;
  GotoXY(20,23); Write('Press any key to continue...');
  REPEAT UNTIL KeyPressed;
  Dummy := ReadKey;
  IF Dummy = Chr(0) THEN Dummy := ReadKey;
  BringScreenBack;
END;
