{->>>>SendMorse<<<<--------------------------------------------}
{                                                              }
{ Filename : SENDMORS.SRC -- Last Modified 7/2/88              }
{                                                              }
{ This procedure converts plain text to audible Morse Code at  }
{ a specified code speed and tone frequency.  The times are    }
{ fairly accurate and have been tested on a 4.77 Mhz PC and a  }
{ 16 Mhz 80386 machine without significant difference in       }
{ code speed.  (Turbo's V3.0 DELAY procedure is finally clock  }
{ speed independent.)  The useful range of the procedure is    }
{ from 10-35 WPM, with best "feel" at 15-25 WPM.               }
{                                                              }
{ Text is passed to SendMorse as quoted strings of plain       }
{ text.  If two characters are to be sent as one without an    }
{ intermediate delay, an asterisk ('*') must precede the two   }
{ characters.  This replaces the overbar used in most amateur  }
{ literature.                                                  }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE SendMorse(PlainText : String;
                    ToneFrequency : Integer;
                    CodeSpeed     : Integer);

VAR
  I            : Integer;
  ToneLength   : Integer;
  DitLength    : Integer;
  CodeChar     : String;
  BlendNextTwo : Boolean;


{ Code is passed to local procedure Morse as literal dots and  }
{ dashes:  '-.-.' = 'C', and so on.  SendMorse converts from   }
{ text to the dot/dash code representation. }

PROCEDURE Morse(CodeChar : String);

VAR
  I : Integer;

BEGIN
  FOR I := 1 TO Length(CodeChar) DO
    BEGIN
      IF CodeChar[1] IN ['.','-'] THEN
        BEGIN
          IF CodeChar[I] = '.' THEN ToneLength := DitLength
            ELSE ToneLength := DitLength * 3;
          Sound(ToneFrequency);
          Delay(ToneLength);
          NoSound;
          Delay(DitLength)
        END
    END
END;

BEGIN
  BlendNextTwo := False;
  { Code speed calculation is derived from formulae published in }
  { the 1986 ARRL Handbook, Section 9-8.   I recommend running   }
  { this procedure at 10 WPM or greater; 15-20 WPM is its most   }
  { effective range.  Timer resolution interferes above 35 WPM.  }
  DitLength := Round((1.2 / CodeSpeed) * 1000.0);
  FOR I := 1 TO Length(PlainText) DO IF PlainText[I] = '*' THEN
    BlendNextTwo := TRUE ELSE
    BEGIN
      PlainText[I] := UpCase(PlainText[I]);
      CASE PlainText[I] OF
        'A' : CodeChar := '.-';
        'B' : CodeChar := '-...';
        'C' : CodeChar := '-.-.';
        'D' : CodeChar := '-..';
        'E' : CodeChar := '.';
        'F' : CodeChar := '..-.';
        'G' : CodeChar := '--.';
        'H' : CodeChar := '....';
        'I' : CodeChar := '..';
        'J' : CodeChar := '.---';
        'K' : CodeChar := '-.-';
        'L' : CodeChar := '.-..';
        'M' : CodeChar := '--';
        'N' : CodeChar := '-.';
        'O' : CodeChar := '---';
        'P' : CodeChar := '.--.';
        'Q' : CodeChar := '--.-';
        'R' : CodeChar := '.-.';
        'S' : CodeChar := '...';
        'T' : CodeChar := '-';
        'U' : CodeChar := '..-';
        'V' : CodeChar := '...-';
        'W' : CodeChar := '.--';
        'X' : CodeChar := '-..-';
        'Y' : CodeChar := '-.--';
        'Z' : CodeChar := '--..';
        '1' : CodeChar := '.----';
        '2' : CodeChar := '..---';
        '3' : CodeChar := '...--';
        '4' : CodeChar := '....-';
        '5' : CodeChar := '.....';
        '6' : CodeChar := '-....';
        '7' : CodeChar := '--...';
        '8' : CodeChar := '---..';
        '9' : CodeChar := '----.';
        '0' : CodeChar := '-----';
        '?' : CodeChar := '..--..';
        '.' : CodeChar := '.-.-.-';
        ',' : CodeChar := '--..--';
        '/' : CodeChar := '-..-.';
        '$' : CodeChar := '...-..-';
        '-' : CodeChar := '-....-';
        ELSE CodeChar := ''
      END; {CASE}
      Morse(CodeChar);
      IF NOT BlendNextTwo THEN Delay(DitLength * 2);
      BlendNextTwo := FALSE
    END;
END;
