{--------------------------------------------------------------}
{                           PieMan                             }
{                                                              }
{              PieSlice demonstration program                  }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 9/3/88               }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM PieMan;

USES Graph;

CONST       { Fill Patterns for pie chart: }
  Halftone1 : FillPatternType =
              ($CC,$33,$CC,$33,$CC,$33,$CC,$33);
  Halftone2 : FillPatternType =
              ($AA,$55,$AA,$55,$AA,$55,$AA,$55);
  Squiggles : FillPatternType =
              ($94,$84,$48,$30,$00,$c1,$22,$14);
  Vertical  : FillPatternType =
              ($CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC);
  Bricks    : FillPatternType =
              ($01,$82,$44,$28,$10,$20,$40,$80);
  Blocks    : FillPatternType =
              ($00,$3C,$42,$42,$42,$42,$3C,$00);


VAR
  GraphDriver : Integer;
  GraphMode   : Integer;
  ErrorCode   : Integer;


{$I ROUNDRCT.SRC}  { RoundedRectangle }


BEGIN
  GraphDriver := Detect;  { Let the BGI determine what board we're using }
  DetectGraph(GraphDriver,GraphMode);
  InitGraph(GraphDriver,GraphMode,'');
  IF GraphResult <> 0 THEN
    BEGIN
      Writeln('>>Halted on graphics error: ',GraphErrorMsg(GraphResult));
      Halt(2)
    END;

  RoundedRectangle(30,30,380,260,35);  { Draw the pie graph frame }

  PieSlice(220,160,0,45,120);          { Draw the pie chart segments }
  SetFillPattern(Bricks,White);
  PieSlice(220,160,45,110,120);
  SetFillPattern(Squiggles,White);
  PieSlice(220,160,110,130,120);
  SetFillPattern(Halftone1,White);
  PieSlice(220,160,130,200,120);
  SetFillPattern(Blocks,White);
  PieSlice(220,160,200,245,120);
  SetFillPattern(Halftone2,White);
  PieSlice(220,160,245,295,120);
  SetFillPattern(Vertical,White);
  PieSlice(220,160,295,360,120);

  SetFillStyle(SolidFill,White); { Set White as fill color }
  PieSlice(500,220,0,360,70);    { Draw a color-filled circle }
  SetFillPattern(Bricks,White);  { Set a fill pattern }
  PieSlice(500,105,0,360,70);    { Draw a pattern-filled circle }

  SetLineStyle(3,0,1); SetFillStyle(EmptyFill,White);
  PieSlice(400,320,0,40,75);

  Readln;
  CloseGraph;
END.
