{--------------------------------------------------------------}
{            TURBO PASCAL 4.0 MOUSE INTERFACE UNIT             }
{                                                              }
{                               by Jeff Duntemann              }
{                               Turbo Pascal V4.0              }
{                               Last Updated 10/26/87          }
{                                                              }
{     From the book, Complete Turbo Pascal, Third Edition      }
{     Scott, Foresman & Company  ISBN                          }
{--------------------------------------------------------------}

UNIT Mouse;

INTERFACE

USES DOS;


VAR
  ButtonCount : Integer;          { Number of buttons on mouse }


FUNCTION IsLogitechMouse : Boolean;          { Looks at driver }

PROCEDURE ResetMouse;         { Standard Mouse function call 0 }

PROCEDURE PointerOn;                                       { 1 }

PROCEDURE PointerOff;                                      { 2 }

PROCEDURE PollMouse(VAR X,Y : Word;
                    VAR Left,Center,Right : Boolean);      { 3 }

PROCEDURE PointerToXY(X,Y : Word);                         { 4 }

PROCEDURE SetColumnRange(High,Low : Word);                 { 7 }

PROCEDURE SetRowRange(High,Low : Word);                    { 8 }

{PROCEDURE MouseCall(VAR M1,M2,M3,M4 : Word); }



{--------------------------------------------------------------}
{                  MOUSE UNIT IMPLEMENTATION                   }
{                                                              }
{  Note that I choose to re-assert the parameter lists in the  }
{  implementation.  It causes no harm and makes this easier    }
{  to read, so why not?  Also note that here, the low-level    }
{  mouse-call procedure Mouser is private to the unit and      }
{  can't be called from outside the unit.  If you wish to do   }
{  more exotic things with the mouse driver (like turn the     }
{  worthless light pen emulation on or off) you should move    }
{  Mouser into the interface to make it accessible.            }
{--------------------------------------------------------------}

IMPLEMENTATION


VAR
  M1,M2,M3,M4 : Word;



PROCEDURE MouseCall(VAR M1,M2,M3,M4 : Word);

VAR
  Regs : Registers;

BEGIN
  WITH Regs DO
    BEGIN
      AX := M1; BX := M2; CX := M3; DX := M4
    END;
  Intr(51,Regs);
  WITH Regs DO
    BEGIN
      M1 := AX; M2 := BX; M3 := CX; M4 := DX
    END
END;


FUNCTION NumberOfMouseButtons : Integer;

BEGIN
  M1 := 0;  { Must reset mouse to count buttons! }
  MouseCall(M1,M2,M3,M4);
  NumberOfMouseButtons := M2
END;



FUNCTION MouseIsInstalled : Boolean;

TYPE
  BytePtr = ^Byte;

VAR
  TestVector : BytePtr;

BEGIN
  GetIntVec(51,Pointer(TestVector));
  { $CF is the binary opcode for the IRET instruction; }
  { in many BIOSes, the startup code puts IRETs into   }
  { most unused bectors. }
  IF (TestVector = NIL) OR (TestVector^ = $CF) THEN
    MouseIsInstalled := False
  ELSE
    MouseIsInstalled := True
END;


{--------------------------------------------------------------}
{      PROCEDURES ABOVE THIS BAR ARE PRIVATE TO THIS UNIT      }
{--------------------------------------------------------------}



FUNCTION IsLogitechMouse : Boolean;

TYPE
  Signature = ARRAY[0..13] OF Char;
  SigPtr = ^Signature;

CONST LogitechSig : Signature = 'LOGITECH MOUSE';

VAR
  TestVector : SigPtr;
  L          : LongInt;

BEGIN
  GetIntVec(51,Pointer(TestVector));
  LongInt(TestVector) := LongInt(TestVector) + 16;
  IF TestVector^ = LogitechSig THEN
    IsLogitechMouse := True
  ELSE
    IsLogitechMouse := False
END;



PROCEDURE ResetMouse;

BEGIN
  M1 := 0;
  MouseCall(M1,M2,M3,M4);
END;


PROCEDURE PointerOn;

BEGIN
  M1 := 1;
  MouseCall(M1,M2,M3,M4)
END;


PROCEDURE PointerOff;

BEGIN
  M1 := 2;
  MouseCall(M1,M2,M3,M4)
END;


PROCEDURE PollMouse(VAR X,Y : Word; VAR Left,Center,Right : Boolean);

BEGIN
  M1 := 3;              { Perform mouse function call 3 }
  MouseCall(M1,M2,M3,M4);
  X := M3; Y := M4;     { Return mouse pointer X,Y position }
  IF (M2 AND $01) = $01 THEN Left := True ELSE Left := False;
  IF (M2 AND $02) = $02 THEN Right := True ELSE Right := False;
  IF (M2 AND $04) = $04 THEN Center := True ELSE Center := False;
END;


PROCEDURE PointerToXY(X,Y : Word);

BEGIN
  M1 := 4;
  M3 := X; M4 := Y;
  MouseCall(M1,M2,M3,M4)
END;


PROCEDURE SetColumnRange(High,Low : Word);

BEGIN
  M1 := 7;
  M3 := Low;
  M4 := High;
  MouseCall(M1,M2,M3,M4)
END;


PROCEDURE SetRowRange(High,Low : Word);

BEGIN
  M1 := 8;
  M3 := Low;
  M4 := High;
  MouseCall(M1,M2,M3,M4)
END;


{--------------------------------------------------------------}
{                   INITIALIZATION SECTION                     }
{                                                              }
{  Function MouseIsInstalled goes out and checks the interrupt }
{  51 vector--if it is either NIL (zeroed) or points to an     }
{  IRET, the mouse is assumed NOT to be installed.  Note that  }
{  a vector table full of garbage may be taken to mean the     }
{  mouse driver is there.  Use the VECTORS utility to check    }
{  the state of your vector table after cold boot.  Some Asian }
{  schlock BIOSes may not initialize the table properly and    }
{  cause a false reading on testing for an installed driver.   }
{--------------------------------------------------------------}


BEGIN
  IF NOT MouseIsInstalled THEN
    BEGIN
      Writeln('>>>ERROR:  Mouse driver not detected.  Aborting to DOS.');
      HALT(1)
    END;
  ButtonCount := NumberOfMouseButtons
END.  {Mouse}
